/*
 * Decompiled with CFR 0.152.
 */
package access.api;

import access.config.Config;
import access.exception.NotFoundException;
import access.manage.EntityType;
import access.manage.Manage;
import access.model.Application;
import access.model.Authority;
import access.model.User;
import access.repository.ApplicationRepository;
import access.repository.RoleRepository;
import access.security.UserPermissions;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/manage", "/api/external/v1/manage"}, produces={"application/json"})
@Transactional
@SecurityRequirements(value={@SecurityRequirement(name="openId", scopes={"openid"}), @SecurityRequirement(name="apiTokens")})
@EnableConfigurationProperties(value={Config.class})
public class ManageController {
    private static final Log LOG = LogFactory.getLog(ManageController.class);
    private final Manage manage;
    private final ApplicationRepository applicationRepository;
    private final RoleRepository roleRepository;

    @Autowired
    public ManageController(Manage manage, ApplicationRepository applicationRepository, RoleRepository roleRepository) {
        this.manage = manage;
        this.applicationRepository = applicationRepository;
        this.roleRepository = roleRepository;
    }

    @GetMapping(value={"provider/{type}/{id}"})
    public ResponseEntity<Map<String, Object>> providerById(@PathVariable(value="type") EntityType type, @PathVariable(value="id") String id, @Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/provider type: %s, id: %s for user %s", type, id, user.getEduPersonPrincipalName()));
        UserPermissions.assertSuperUser((User)user);
        Map provider = this.manage.providerById(type, id);
        return ResponseEntity.ok((Object)provider);
    }

    @GetMapping(value={"providers"})
    public ResponseEntity<List<Map<String, Object>>> providers(@Parameter(hidden=true) User user) {
        LOG.debug((Object)String.format("GET /manage/providers for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertAuthority((User)user, (Authority)Authority.SUPER_USER);
        List providers = this.manage.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        return ResponseEntity.ok((Object)providers);
    }

    @GetMapping(value={"organization-guid-validation/{organizationGUID}"})
    public ResponseEntity<Map<String, Object>> organizationGUIDValidation(@Parameter(hidden=true) User user, @PathVariable(value="organizationGUID") String organizationGUID) {
        LOG.debug((Object)String.format("GET /manage/organization-guid-validation guid: %s for user %s", organizationGUID, user.getEduPersonPrincipalName()));
        UserPermissions.assertSuperUser((User)user);
        List identityProviders = this.manage.identityProvidersByInstitutionalGUID(organizationGUID);
        if (CollectionUtils.isEmpty((Collection)identityProviders)) {
            new NotFoundException("No identity provider with organizationGUID: " + organizationGUID);
        }
        return ResponseEntity.ok((Object)((Map)identityProviders.getFirst()));
    }

    @GetMapping(value={"applications"})
    public ResponseEntity<Map<String, List<Map<String, Object>>>> applications(@Parameter(hidden=true) User user) {
        LOG.debug((Object)"/applications");
        LOG.debug((Object)String.format("GET /manage/applications for user %s", user.getEduPersonPrincipalName()));
        UserPermissions.assertInstitutionAdmin((User)user);
        List<Application> applications = user.isSuperUser() ? this.applicationRepository.findAll() : this.roleRepository.findByOrganizationGUID(user.getOrganizationGUID()).stream().map(role -> role.getApplicationUsages()).flatMap(Collection::stream).map(applicationUsage -> applicationUsage.getApplication()).toList();
        Map<EntityType, List<Application>> groupedByManageType = applications.stream().collect(Collectors.groupingBy(Application::getManageType));
        List providers = groupedByManageType.entrySet().stream().map(entry -> this.manage.providersByIdIn((EntityType)entry.getKey(), ((List)entry.getValue()).stream().map(Application::getManageId).collect(Collectors.toList()))).flatMap(Collection::stream).toList();
        Map<String, Long> applicationsPerManageId = this.applicationRepository.countByApplications().stream().collect(Collectors.toMap(m -> (String)m.get("manage_id"), m -> (Long)m.get("role_count")));
        providers.forEach(provider -> {
            Long roleCount = applicationsPerManageId.getOrDefault(provider.get("id"), 0L);
            provider.put("roleCount", roleCount);
        });
        List provisionings = this.manage.provisioning(applications.stream().map(Application::getManageId).toList());
        return ResponseEntity.ok(Map.of("providers", providers, "provisionings", provisionings));
    }
}

