/*
 * Decompiled with CFR 0.152.
 */
package aa.shibboleth;

import aa.shibboleth.FederatedUser;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String NAME_ID_HEADER_NAME = "name-id";
    public static final String DISPLAY_NAME_HEADER_NAME = "displayname";
    public static final String SCHAC_HOME_HEADER = "schacHomeOrganization";

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager) {
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = this.getHeader(NAME_ID_HEADER_NAME, request);
        String displayName = this.getHeader(DISPLAY_NAME_HEADER_NAME, request);
        String schacHomeOrganization = this.getHeader(SCHAC_HOME_HEADER, request);
        if (!StringUtils.hasText((String)uid)) {
            return null;
        }
        return new FederatedUser(uid, displayName, schacHomeOrganization, AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_ADMIN"}));
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

