/*
 * Decompiled with CFR 0.152.
 */
package aa.aggregators.manage;

import aa.aggregators.AbstractAttributeAggregator;
import aa.aggregators.manage.ManageConfig;
import aa.model.ArpValue;
import aa.model.AttributeAuthorityConfiguration;
import aa.model.UserAttribute;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

public abstract class ManageAttributeAggregator
extends AbstractAttributeAggregator {
    private final HttpHeaders httpHeaders = new HttpHeaders();

    public ManageAttributeAggregator(AttributeAuthorityConfiguration attributeAuthorityConfiguration) {
        super(attributeAuthorityConfiguration);
        this.httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        this.httpHeaders.setContentType(MediaType.APPLICATION_JSON);
    }

    protected abstract List<UserAttribute> processResult(List<Map> var1);

    protected abstract ManageConfig manageConfig();

    String getMetaDataValue(List<Map> result, String attributeName) {
        Map data = (Map)result.get(0).get("data");
        Map metaDataFields = (Map)data.get("metaDataFields");
        return (String)metaDataFields.get(attributeName);
    }

    public List<UserAttribute> aggregate(List<UserAttribute> input, Map<String, List<ArpValue>> arpAttributes) {
        ManageConfig manageConfig = this.manageConfig();
        String searchValue = this.getUserAttributeSingleValue(input, manageConfig.getSamlQueryParameter());
        URI endpoint = this.endpoint("/manage/api/internal/search/" + manageConfig.getMetaDataType());
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put(manageConfig.getManageQueryParameter(), searchValue);
        body.put("REQUESTED_ATTRIBUTES", Collections.singletonList(manageConfig.getRequestAttribute()));
        List result = (List)this.getRestTemplate().exchange(endpoint, HttpMethod.POST, new HttpEntity(body, (MultiValueMap)this.httpHeaders), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).getBody();
        this.LOG.debug("Retrieved Manage information with request: {} and response: {}", body, (Object)result);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return Collections.emptyList();
        }
        return this.processResult(result);
    }
}

