/*
 * Decompiled with CFR 0.152.
 */
package invite.repository;

import invite.model.Invitation;
import invite.model.Role;
import invite.model.Status;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.stereotype.Repository;

@Repository
public interface InvitationRepository
extends JpaRepository<Invitation, Long>,
QueryRewriter {
    @EntityGraph(value="findByHash", type=EntityGraph.EntityGraphType.LOAD, attributePaths={"inviter", "roles", "roles.role"})
    public Optional<Invitation> findByHash(String var1);

    public Optional<Invitation> findTopBySubInviteeOrderByCreatedAtDesc(String var1);

    public List<Invitation> findByStatus(Status var1);

    public List<Invitation> findByStatusAndRoles_role(Status var1, Role var2);

    public long countByStatus(Status var1);

    @Query(value="SELECT i.id, i.email, i.remote_api_user, i.intended_authority, i.created_at, i.expiry_date,\nu.id as user_id, u.name, u.email as inviter_email\nFROM invitations i LEFT JOIN users u ON u.id = i.inviter_id\nWHERE i.status = ?1\n", countQuery="SELECT count(*) FROM invitations WHERE status = ?1", queryRewriter=InvitationRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByStatusPage(String var1, Pageable var2);

    @Query(value="SELECT i.id, i.email, i.remote_api_user, i.intended_authority,i.created_at, i.expiry_date,\nu.id as user_id, u.name, u.email as inviter_email\nFROM invitations i LEFT JOIN users u ON u.id = i.inviter_id\nWHERE i.status = ?1 AND\n(MATCH(i.email) AGAINST(?2 IN BOOLEAN MODE)\n OR MATCH (u.given_name, u.family_name, u.email) against (?2  IN BOOLEAN MODE))\n", countQuery=" SELECT count(*) FROM invitations i LEFT JOIN users u ON u.id = i.inviter_id\n WHERE status = ?1 AND\n (MATCH(i.email) AGAINST(?2 IN BOOLEAN MODE)\n OR MATCH (u.given_name, u.family_name, u.email) against (?2 IN BOOLEAN MODE))\n", queryRewriter=InvitationRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByStatusPageWithKeyword(String var1, String var2, Pageable var3);

    @Query(value="SELECT i.id, i.email, i.remote_api_user, i.intended_authority,i.created_at, i.expiry_date,\nu.id as user_id, u.name, u.email as inviter_email\nFROM invitations i LEFT JOIN users u ON u.id = i.inviter_id INNER JOIN invitation_roles ir ON ir.invitation_id = i.id\nINNER JOIN roles r ON r.id = ir.role_id\nWHERE i.status = ?1 AND r.id = ?2\n", countQuery="SELECT count(*) FROM invitations i\nINNER JOIN invitation_roles ir ON ir.invitation_id = i.id\nINNER JOIN roles r ON r.id = ir.role_id\nWHERE status = ?1 and role_id = ?2\n", queryRewriter=InvitationRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByStatusAndRolePage(String var1, Long var2, Pageable var3);

    @Query(value="SELECT i.id, i.email, i.remote_api_user, i.intended_authority,i.created_at, i.expiry_date,\nu.id as user_id, u.name, u.email as inviter_email\nFROM invitations i LEFT JOIN users u ON u.id = i.inviter_id INNER JOIN invitation_roles ir ON ir.invitation_id = i.id\nINNER JOIN roles r ON r.id = ir.role_id\nWHERE i.status = ?1 AND r.id = ?2 AND\n(MATCH(i.email) AGAINST(?3 IN BOOLEAN MODE)\n OR MATCH (u.given_name, u.family_name, u.email) against (?3 IN BOOLEAN MODE))\n", countQuery="SELECT count(*) FROM invitations i\nINNER JOIN invitation_roles ir ON ir.invitation_id = i.id\nINNER JOIN roles r ON r.id = ir.role_id\nLEFT JOIN users u ON u.id = i.inviter_id\nWHERE status = ?1 and role_id = ?2 AND\n(MATCH(i.email) AGAINST(?3 IN BOOLEAN MODE)\n OR MATCH (u.given_name, u.family_name, u.email) against (?3 IN BOOLEAN MODE))\n", queryRewriter=InvitationRepository.class, nativeQuery=true)
    public Page<Map<String, Object>> searchByStatusAndRoleWithKeywordPage(String var1, Long var2, String var3, Pageable var4);

    @Query(value="    SELECT ir.invitation_id as id, r.name, r.id as role_id, a.manage_id\n    FROM roles r INNER JOIN invitation_roles ir ON ir.role_id = r.id\n    INNER JOIN application_usages au ON au.role_id = r.id\n    INNER JOIN applications a ON a.id = au.application_id\n    WHERE ir.invitation_id IN ?1\n", nativeQuery=true)
    public List<Map<String, Object>> findRoles(List<Long> var1);

    default public String rewrite(String query, Sort sort) {
        Sort.Order nameSort = sort.getOrderFor("name");
        if (nameSort != null) {
            return query.replace("order by i.name", "order by u.name");
        }
        return query;
    }
}

