/*
 * Decompiled with CFR 0.152.
 */
package invite.cron;

import invite.model.User;
import invite.model.UserRole;
import invite.provision.ProvisioningService;
import invite.provision.scim.OperationType;
import invite.repository.UserRepository;
import invite.repository.UserRoleRepository;
import java.io.Serializable;
import java.time.Instant;
import java.time.Period;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResourceCleaner {
    private static final Log LOG = LogFactory.getLog(ResourceCleaner.class);
    private final UserRepository userRepository;
    private final ProvisioningService provisioningService;
    private final UserRoleRepository userRoleRepository;
    private final boolean cronJobResponsible;
    private final int lastActivityDurationDays;

    @Autowired
    public ResourceCleaner(UserRepository userRepository, UserRoleRepository userRoleRepository, ProvisioningService provisioningService, @Value(value="${cron.last-activity-duration-days}") int lastActivityDurationDays, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.userRepository = userRepository;
        this.userRoleRepository = userRoleRepository;
        this.lastActivityDurationDays = lastActivityDurationDays;
        this.cronJobResponsible = cronJobResponsible;
        this.provisioningService = provisioningService;
    }

    @Scheduled(cron="${cron.user-cleaner-expression}")
    @Transactional
    public void clean() {
        if (!this.cronJobResponsible) {
            return;
        }
        this.doClean();
    }

    public Map<String, List<? extends Serializable>> doClean() {
        List users = this.cleanNonActiveUsers();
        List orphans = this.cleanOrphanedUser();
        List userRoles = this.cleanUserRoles();
        return Map.of("DeletedNonActiveUsers", users, "DeletedOrphanUsers", orphans, "DeletedExpiredUserRoles", userRoles);
    }

    private List<User> cleanNonActiveUsers() {
        Instant past = Instant.now().minus(Period.ofDays(this.lastActivityDurationDays));
        List users = this.userRepository.findByLastActivityBefore(past);
        LOG.info((Object)String.format("Deleted %s users with no activity in the last %s days: %s ", users.size(), this.lastActivityDurationDays, users.stream().map(User::getEduPersonPrincipalName).collect(Collectors.joining(", "))));
        users.forEach(arg_0 -> ((ProvisioningService)this.provisioningService).deleteUserRequest(arg_0));
        this.userRepository.deleteAll((Iterable)users);
        return users;
    }

    private List<User> cleanOrphanedUser() {
        List orphans = this.userRepository.findNonSuperUserWithoutUserRoles();
        LOG.info((Object)String.format("Deleted %s non-super users with no userRoles; %s", orphans.size(), orphans.stream().map(User::getEduPersonPrincipalName).collect(Collectors.joining(", "))));
        orphans.forEach(arg_0 -> ((ProvisioningService)this.provisioningService).deleteUserRequest(arg_0));
        this.userRepository.deleteAll((Iterable)orphans);
        return orphans;
    }

    private List<UserRole> cleanUserRoles() {
        List userRoles = this.userRoleRepository.findByEndDateBeforeAndExpiryNotifications(Instant.now(), Integer.valueOf(1));
        LOG.info((Object)String.format("Deleted %s userRoles with an endDate in the past: %s", userRoles.size(), userRoles.stream().map(userRole -> String.format("%s - %s", userRole.getUser().getEduPersonPrincipalName(), userRole.getRole().getName())).collect(Collectors.toList())));
        userRoles.forEach(userRole -> this.provisioningService.updateGroupRequest(userRole, OperationType.Remove));
        userRoles.forEach(userRole -> {
            User user = userRole.getUser();
            user.removeUserRole(userRole);
            this.userRepository.save((Object)user);
        });
        return userRoles;
    }
}

