/*
 * Decompiled with CFR 0.152.
 */
package invite.validation;

import invite.validation.FormatValidator;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class EmailFormatValidator
implements FormatValidator {
    private static final Pattern pattern = Pattern.compile("^.+@.+$", 2);

    public boolean isValid(String subject) {
        return StringUtils.hasText((String)subject) && !this.hasMoreThanOneAt(subject) && pattern.matcher(subject).matches();
    }

    private boolean hasMoreThanOneAt(String input) {
        return input.indexOf(64) != -1 && input.indexOf(64) != input.lastIndexOf(64);
    }

    public String formatName() {
        return "email";
    }
}

