/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.exception.UserRestrictionException;
import invite.model.Role;
import invite.security.RemoteUser;
import invite.security.Scope;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.stream.Streams;

/*
 * Exception performing whole class analysis ignored.
 */
public class RemoteUserPermissions {
    private RemoteUserPermissions() {
    }

    public static void assertScopeAccess(RemoteUser remoteUser, Scope ... scopes) {
        if (remoteUser == null) {
            throw new UserRestrictionException();
        }
        if (scopes == null || scopes.length == 0) {
            return;
        }
        if (!Streams.of((Object[])scopes).allMatch(scope -> remoteUser.getScopes().contains(scope))) {
            throw new UserRestrictionException();
        }
    }

    public static void assertApplicationAccess(RemoteUser remoteUser, Role role) {
        RemoteUserPermissions.assertApplicationAccess((RemoteUser)remoteUser, List.of(role));
    }

    public static void assertApplicationAccess(RemoteUser remoteUser, List<Role> roles) {
        if (remoteUser == null) {
            throw new UserRestrictionException();
        }
        if (remoteUser.isLocalDevMode()) {
            return;
        }
        List remoteUserApplications = remoteUser.getApplications();
        boolean hasApplicationAccess = roles.stream().map(role -> role.applicationsUsed()).flatMap(Collection::stream).allMatch(application -> remoteUserApplications.stream().anyMatch(remoteUserApplication -> remoteUserApplication.getManageId().equals(application.getManageId()) && remoteUserApplication.getManageType().equals((Object)application.getManageType())));
        if (!hasApplicationAccess) {
            throw new UserRestrictionException();
        }
    }
}

