/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.manage.Manage;
import invite.model.Authority;
import invite.repository.InvitationRepository;
import jakarta.servlet.http.HttpSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthorizationRequestCustomizer
implements Consumer<OAuth2AuthorizationRequest.Builder> {
    private final InvitationRepository invitationRepository;
    private final String eduidEntityId;
    private final Manage manage;

    public AuthorizationRequestCustomizer(InvitationRepository invitationRepository, String eduidEntityId, Manage manage) {
        this.invitationRepository = invitationRepository;
        this.eduidEntityId = eduidEntityId;
        this.manage = manage;
    }

    @Override
    public void accept(OAuth2AuthorizationRequest.Builder builder) {
        builder.additionalParameters(params -> {
            String[] hash;
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            HttpSession session = ((ServletRequestAttributes)requestAttributes).getRequest().getSession(false);
            if (session == null) {
                return;
            }
            DefaultSavedRequest savedRequest = (DefaultSavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
            String[] force = savedRequest.getParameterValues("force");
            if (force != null && force.length == 1) {
                params.put("prompt", "login");
            }
            if ((hash = savedRequest.getParameterValues("hash")) != null && hash.length == 1) {
                Optional optionalInvitation = this.invitationRepository.findByHash(hash[0]);
                optionalInvitation.ifPresent(invitation -> {
                    boolean guestInvitation = invitation.getIntendedAuthority().equals((Object)Authority.GUEST);
                    if (invitation.isEduIDOnly() && guestInvitation) {
                        params.put("login_hint", this.eduidEntityId);
                    } else if (!invitation.isEduIDOnly() && guestInvitation) {
                        List<String> entityIdentifiers = invitation.getRoles().stream().map(role -> role.getRole().getApplicationUsages()).flatMap(Collection::stream).map(applicationUsage -> applicationUsage.getApplication()).map(application -> this.manage.providerById(application.getManageType(), application.getManageId())).map(provider -> (String)((Map)provider.get("data")).get("entityid")).distinct().toList();
                        List idpList = this.manage.idpEntityIdentifiersByServiceEntityId(entityIdentifiers);
                        params.put("login_hint", idpList.stream().collect(Collectors.joining(",")));
                    }
                });
            }
        });
    }
}

