/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.manage.Manage;
import invite.model.User;
import invite.provision.ProvisioningService;
import invite.repository.UserRepository;
import invite.security.InstitutionAdmin;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.StringUtils;

public class CustomOidcUserService
implements OAuth2UserService<OidcUserRequest, OidcUser> {
    private static final Log LOG = LogFactory.getLog(CustomOidcUserService.class);
    private final Manage manage;
    private final ProvisioningService provisioningService;
    private final UserRepository userRepository;
    private final String entitlement;
    private final String organizationGuidPrefix;
    private final OidcUserService delegate;

    public CustomOidcUserService(Manage manage, UserRepository userRepository, ProvisioningService provisioningService, String entitlement, String organizationGuidPrefix) {
        this.manage = manage;
        this.userRepository = userRepository;
        this.provisioningService = provisioningService;
        this.entitlement = entitlement;
        this.organizationGuidPrefix = organizationGuidPrefix;
        this.delegate = new OidcUserService();
    }

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = this.delegate.loadUser(userRequest);
        Map claims = oidcUser.getUserInfo().getClaims();
        HashMap<String, Object> newClaims = new HashMap<String, Object>(claims);
        String sub = (String)newClaims.get("sub");
        Optional optionalUser = this.userRepository.findBySubIgnoreCase(sub);
        boolean institutionAdmin = InstitutionAdmin.isInstitutionAdmin((Map)claims, (String)this.entitlement) || optionalUser.isPresent() && InstitutionAdmin.isInstitutionAdmin((User)((User)optionalUser.get()));
        newClaims.put("INSTITUTION_ADMIN", institutionAdmin);
        String organizationGuid = institutionAdmin ? (String)InstitutionAdmin.getOrganizationGuid((Map)claims, (String)this.organizationGuidPrefix, (Optional)optionalUser).orElse(null) : null;
        newClaims.put("ORGANIZATION_GUID", organizationGuid);
        if (institutionAdmin && StringUtils.hasText((String)organizationGuid)) {
            Map manageClaims = this.manage.enrichInstitutionAdmin(organizationGuid);
            newClaims.putAll(manageClaims);
        }
        optionalUser.ifPresent(user -> {
            boolean changed = user.updateAttributes(newClaims);
            if (changed) {
                try {
                    this.provisioningService.updateUserRequest(user);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)"Error in updateUserRequest", (Throwable)e);
                }
            }
            this.userRepository.save(user);
        });
        OidcUserInfo oidcUserInfo = new OidcUserInfo(newClaims);
        return new DefaultOidcUser(oidcUser.getAuthorities(), oidcUser.getIdToken(), oidcUserInfo);
    }

    @Generated
    public Manage getManage() {
        return this.manage;
    }
}

