/*
 * Decompiled with CFR 0.152.
 */
package invite.model;

import invite.exception.InvalidInputException;
import invite.model.Authority;
import invite.model.Invite;
import invite.model.Language;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.util.CollectionUtils;

public class InvitationRequest
implements Serializable {
    @NotNull
    private Authority intendedAuthority;
    private String message;
    private Language language;
    private boolean enforceEmailEquality;
    private boolean eduIDOnly;
    private boolean guestRoleIncluded;
    private boolean suppressSendingEmails;
    private List<String> invites;
    private List<Invite> invitesWithInternalPlaceholderIdentifiers;
    private List<Long> roleIdentifiers;
    private String organizationGUID;
    private Instant roleExpiryDate;
    @NotNull
    private Instant expiryDate;

    public void verify() {
        if (CollectionUtils.isEmpty((Collection)this.invitesWithInternalPlaceholderIdentifiers) && CollectionUtils.isEmpty((Collection)this.invites)) {
            throw new InvalidInputException("Either at least one value for invitesWithInternalPlaceholderIdentifiers or invites is required");
        }
    }

    @Generated
    public Authority getIntendedAuthority() {
        return this.intendedAuthority;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Language getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isEnforceEmailEquality() {
        return this.enforceEmailEquality;
    }

    @Generated
    public boolean isEduIDOnly() {
        return this.eduIDOnly;
    }

    @Generated
    public boolean isGuestRoleIncluded() {
        return this.guestRoleIncluded;
    }

    @Generated
    public boolean isSuppressSendingEmails() {
        return this.suppressSendingEmails;
    }

    @Generated
    public List<String> getInvites() {
        return this.invites;
    }

    @Generated
    public List<Invite> getInvitesWithInternalPlaceholderIdentifiers() {
        return this.invitesWithInternalPlaceholderIdentifiers;
    }

    @Generated
    public List<Long> getRoleIdentifiers() {
        return this.roleIdentifiers;
    }

    @Generated
    public String getOrganizationGUID() {
        return this.organizationGUID;
    }

    @Generated
    public Instant getRoleExpiryDate() {
        return this.roleExpiryDate;
    }

    @Generated
    public Instant getExpiryDate() {
        return this.expiryDate;
    }

    @Generated
    public void setIntendedAuthority(Authority intendedAuthority) {
        this.intendedAuthority = intendedAuthority;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setLanguage(Language language) {
        this.language = language;
    }

    @Generated
    public void setEnforceEmailEquality(boolean enforceEmailEquality) {
        this.enforceEmailEquality = enforceEmailEquality;
    }

    @Generated
    public void setEduIDOnly(boolean eduIDOnly) {
        this.eduIDOnly = eduIDOnly;
    }

    @Generated
    public void setGuestRoleIncluded(boolean guestRoleIncluded) {
        this.guestRoleIncluded = guestRoleIncluded;
    }

    @Generated
    public void setSuppressSendingEmails(boolean suppressSendingEmails) {
        this.suppressSendingEmails = suppressSendingEmails;
    }

    @Generated
    public void setInvites(List<String> invites) {
        this.invites = invites;
    }

    @Generated
    public void setInvitesWithInternalPlaceholderIdentifiers(List<Invite> invitesWithInternalPlaceholderIdentifiers) {
        this.invitesWithInternalPlaceholderIdentifiers = invitesWithInternalPlaceholderIdentifiers;
    }

    @Generated
    public void setRoleIdentifiers(List<Long> roleIdentifiers) {
        this.roleIdentifiers = roleIdentifiers;
    }

    @Generated
    public void setOrganizationGUID(String organizationGUID) {
        this.organizationGUID = organizationGUID;
    }

    @Generated
    public void setRoleExpiryDate(Instant roleExpiryDate) {
        this.roleExpiryDate = roleExpiryDate;
    }

    @Generated
    public void setExpiryDate(Instant expiryDate) {
        this.expiryDate = expiryDate;
    }

    @Generated
    public InvitationRequest() {
    }

    @Generated
    public InvitationRequest(Authority intendedAuthority, String message, Language language, boolean enforceEmailEquality, boolean eduIDOnly, boolean guestRoleIncluded, boolean suppressSendingEmails, List<String> invites, List<Invite> invitesWithInternalPlaceholderIdentifiers, List<Long> roleIdentifiers, String organizationGUID, Instant roleExpiryDate, Instant expiryDate) {
        this.intendedAuthority = intendedAuthority;
        this.message = message;
        this.language = language;
        this.enforceEmailEquality = enforceEmailEquality;
        this.eduIDOnly = eduIDOnly;
        this.guestRoleIncluded = guestRoleIncluded;
        this.suppressSendingEmails = suppressSendingEmails;
        this.invites = invites;
        this.invitesWithInternalPlaceholderIdentifiers = invitesWithInternalPlaceholderIdentifiers;
        this.roleIdentifiers = roleIdentifiers;
        this.organizationGUID = organizationGUID;
        this.roleExpiryDate = roleExpiryDate;
        this.expiryDate = expiryDate;
    }
}

