/*
 * Decompiled with CFR 0.152.
 */
package invite.cron;

import invite.cron.Executable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractNodeLeader {
    private static final Log LOG = LogFactory.getLog(AbstractNodeLeader.class);
    private final String lockName;
    private final int timeoutSeconds;
    private final DataSource dataSource;

    protected AbstractNodeLeader(String lockName, int timeoutSeconds, DataSource dataSource) {
        this.lockName = lockName;
        this.timeoutSeconds = timeoutSeconds;
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void perform(String name, Executable executable) {
        block31: {
            boolean lockAcquired;
            Connection conn;
            block30: {
                block28: {
                    block29: {
                        conn = null;
                        lockAcquired = false;
                        conn = this.dataSource.getConnection();
                        lockAcquired = this.tryGetLock(conn, this.lockName, this.timeoutSeconds);
                        if (lockAcquired) break block28;
                        LOG.info((Object)String.format("Another node is running %s, skipping this one", name));
                        if (!lockAcquired) break block29;
                        try {
                            this.releaseLock(conn, this.lockName);
                            LOG.info((Object)String.format("Lock released for %s", name));
                        }
                        catch (Exception e) {
                            LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                LOG.info((Object)String.format("Lock acquired for %s", name));
                executable.execute();
                LOG.info((Object)String.format("Executable %s completed successfully", name));
                if (!lockAcquired) break block30;
                try {
                    this.releaseLock(conn, this.lockName);
                    LOG.info((Object)String.format("Lock released for %s", name));
                }
                catch (Exception e) {
                    LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
            break block31;
            catch (Throwable e) {
                block32: {
                    try {
                        LOG.error((Object)String.format("Error occurred in %s", name), e);
                        if (!lockAcquired) break block32;
                    }
                    catch (Throwable throwable) {
                        if (lockAcquired) {
                            try {
                                this.releaseLock(conn, this.lockName);
                                LOG.info((Object)String.format("Lock released for %s", name));
                            }
                            catch (Exception e2) {
                                LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e2);
                            }
                        }
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        this.releaseLock(conn, this.lockName);
                        LOG.info((Object)String.format("Lock released for %s", name));
                    }
                    catch (Exception e3) {
                        LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e3);
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private boolean tryGetLock(Connection conn, String name, int timeoutSec) throws Exception {
        try (PreparedStatement ps = conn.prepareStatement("SELECT GET_LOCK(?, ?)");){
            boolean bl;
            block16: {
                ResultSet rs;
                block14: {
                    boolean bl2;
                    block15: {
                        ps.setString(1, name);
                        ps.setInt(2, timeoutSec);
                        rs = ps.executeQuery();
                        try {
                            if (!rs.next()) break block14;
                            int result = rs.getInt(1);
                            boolean bl3 = bl2 = !rs.wasNull() && result == 1;
                            if (rs == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return bl2;
                }
                bl = false;
                if (rs == null) break block16;
                rs.close();
            }
            return bl;
        }
    }

    private void releaseLock(Connection conn, String name) throws Exception {
        try (PreparedStatement ps = conn.prepareStatement("SELECT RELEASE_LOCK(?)");){
            ps.setString(1, name);
            ps.executeQuery();
        }
    }
}

