/*
 * Decompiled with CFR 0.152.
 */
package invite.mail;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import invite.cron.IdPMetaDataResolver;
import invite.model.Authority;
import invite.model.GroupedProviders;
import invite.model.Invitation;
import invite.model.Language;
import invite.model.Provisionable;
import invite.model.User;
import invite.model.UserRole;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.ClassPathResource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MailBox {
    private final JavaMailSender mailSender;
    private final String clientUrl;
    private final String welcomeUrl;
    private final String emailFrom;
    private final String contactEmail;
    private final String environment;
    private final Map<String, Map<String, String>> subjects;
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory("templates");
    private final IdPMetaDataResolver idPMetaDataResolver;

    public MailBox(ObjectMapper objectMapper, IdPMetaDataResolver idPMetaDataResolver, JavaMailSender mailSender, String emailFrom, String contactEmail, String clientUrl, String welcomeUrl, String environment) throws IOException {
        this.mailSender = mailSender;
        this.idPMetaDataResolver = idPMetaDataResolver;
        this.emailFrom = emailFrom;
        this.contactEmail = contactEmail;
        this.clientUrl = clientUrl;
        this.welcomeUrl = welcomeUrl;
        this.environment = environment;
        this.subjects = (Map)objectMapper.readValue(new ClassPathResource("/templates/subjects.json").getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sendInviteMail(Provisionable provisionable, Invitation invitation, List<GroupedProviders> groupedProviders, Language language, Optional<String> optionalIdpName) {
        Authority intendedAuthority = invitation.getIntendedAuthority();
        String title = String.format((String)((Map)this.subjects.get(language.name())).get("newInvitation"), invitation.getRoles().stream().map(role -> role.getRole().getName()).collect(Collectors.joining(", ")));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("groupedProviders", groupedProviders);
        variables.put("title", title);
        if (provisionable instanceof User) {
            User user = (User)provisionable;
            variables.put("institutionName", this.idPMetaDataResolver.getIdentityProvider(user.getSchacHomeOrganization()).map(idp -> idp.getName()).orElse(user.getSchacHomeOrganization()));
        } else {
            variables.put("institutionName", "SURF");
        }
        optionalIdpName.ifPresent(idpName -> variables.put("idpName", idpName));
        variables.put("roles", this.splitListSemantically(invitation.getRoles().stream().map(invitationRole -> invitationRole.getRole().getName()).toList()));
        if (invitation.getRoles().stream().anyMatch(invitationRole -> StringUtils.hasText((String)invitationRole.getRole().getInviterDisplayName()))) {
            variables.put("displaySenderName", this.splitListSemantically(invitation.getRoles().stream().map(invitationRole -> invitationRole.getRole().getInviterDisplayName()).toList()));
        } else {
            variables.put("displaySenderName", provisionable.getName());
        }
        if (StringUtils.hasText((String)invitation.getMessage())) {
            variables.put("message", invitation.getMessage().replaceAll("\n", "<br/>"));
        }
        variables.put("invitation", invitation);
        variables.put("intendedAuthority", invitation.getIntendedAuthority().translate(language.name()));
        variables.put("user", provisionable);
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        String url = intendedAuthority.equals((Object)Authority.GUEST) ? this.welcomeUrl : this.clientUrl;
        variables.put("url", String.format("%s/invitation/accept?hash=%s", url, invitation.getHash()));
        variables.put("useEduID", invitation.isEduIDOnly() && invitation.getIntendedAuthority().equals((Object)Authority.GUEST));
        this.sendMail(String.format("invitation_%s", language.name()), title, variables, new String[]{invitation.getEmail()});
    }

    public String inviteMailURL(Invitation invitation) {
        Authority intendedAuthority = invitation.getIntendedAuthority();
        String url = intendedAuthority.equals((Object)Authority.GUEST) ? this.welcomeUrl : this.clientUrl;
        return String.format("%s/invitation/accept?hash=%s", url, invitation.getHash());
    }

    public String sendUserRoleExpirationNotificationMail(UserRole userRole, GroupedProviders groupedProvider, int nbrOfDays) {
        String lang = this.preferredLanguage().toLowerCase();
        String title = String.format((String)((Map)this.subjects.get(lang)).get("roleExpirationNotification"), userRole.getAuthority().translate(lang), userRole.getRole().getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("title", title);
        variables.put("userRole", userRole);
        if (groupedProvider != null) {
            variables.put("groupedProvider", groupedProvider);
        }
        variables.put("nbrOfDays", nbrOfDays);
        variables.put("contactEmail", this.contactEmail);
        variables.put("authority", userRole.getAuthority().translate(lang));
        if (!this.environment.equalsIgnoreCase("prod")) {
            variables.put("environment", this.environment);
        }
        return this.sendMail(String.format("role_expiration_%s", lang), title, variables, new String[]{userRole.getUser().getEmail()});
    }

    private String preferredLanguage() {
        return LocaleContextHolder.getLocale().getLanguage();
    }

    private String sendMail(String templateName, String subject, Map<String, Object> variables, String ... to) throws MessagingException, IOException {
        String htmlText = this.mailTemplate(templateName + ".html", variables);
        String plainText = this.mailTemplate(templateName + ".txt", variables);
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setSubject(subject);
        this.setText(plainText, htmlText, helper);
        helper.setTo(to);
        helper.setFrom(this.emailFrom);
        this.doSendMail(message);
        return htmlText;
    }

    protected void setText(String plainText, String htmlText, MimeMessageHelper helper) throws MessagingException, IOException {
        helper.setText(plainText, htmlText);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }

    private String mailTemplate(String templateName, Map<String, Object> context) {
        return this.mustacheFactory.compile(templateName).execute((Writer)new StringWriter(), context).toString();
    }

    private String splitListSemantically(List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return "";
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        String separator = this.preferredLanguage().toLowerCase().equals("en") ? " and " : " en ";
        return values.subList(0, values.size() - 1).stream().collect(Collectors.joining(", ")) + separator + values.get(values.size() - 1);
    }
}

