/*
 * Decompiled with CFR 0.152.
 */
package invite.manage;

import invite.manage.EntityType;
import invite.manage.Manage;
import invite.manage.ResilientErrorHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RemoteManage
implements Manage {
    private static final Log LOG = LogFactory.getLog(RemoteManage.class);
    private final String url;
    private final RestTemplate restTemplate = new RestTemplate();

    public RemoteManage(String url, String user, String password) {
        this.url = url;
        this.restTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(user, password));
        ResilientErrorHandler resilientErrorHandler = new ResilientErrorHandler();
        this.restTemplate.setErrorHandler((ResponseErrorHandler)resilientErrorHandler);
    }

    public List<Map<String, Object>> providers(EntityType ... entityTypes) {
        LOG.debug((Object)("Providers for entityTypes: " + String.valueOf(List.of(entityTypes))));
        return Stream.of(entityTypes).map(entityType -> this.getRemoteMetaData(entityType.collectionName())).flatMap(Collection::stream).toList();
    }

    public List<Map<String, Object>> providersByIdIn(EntityType entityType, List<String> identifiers) {
        LOG.debug((Object)String.format("providersByIdIn %s", entityType));
        if (CollectionUtils.isEmpty(identifiers)) {
            LOG.debug((Object)"No identifiers in providersByIdIn");
            return Collections.emptyList();
        }
        String param = identifiers.stream().map(id -> String.format("\"%s\"", id)).collect(Collectors.joining(","));
        String body = String.format("{ \"id\": { \"$in\": [%s]}}", param);
        String manageUrl = String.format("%s/manage/api/internal/rawSearch/%s", this.url, entityType.collectionName());
        List providers = (List)this.restTemplate.postForObject(manageUrl, (Object)body, List.class, new Object[0]);
        if (providers != null) {
            LOG.debug((Object)String.format("Got %d results for providersByIdIn", providers.size()));
        }
        return this.transformProvider(providers);
    }

    public List<String> idpEntityIdentifiersByServiceEntityId(List<String> serviceEntityIdentifiers) {
        LOG.debug((Object)"idpEntityIdentifiersByServiceEntityId");
        if (CollectionUtils.isEmpty(serviceEntityIdentifiers)) {
            LOG.debug((Object)"No identifiers in idpEntityIdentifiersByServiceEntityId");
            return Collections.emptyList();
        }
        Map<String, List<String>> body = Map.of("allowedEntities.name", serviceEntityIdentifiers, "allowedall", true, "LOGICAL_OPERATOR_IS_AND", false, "REQUESTED_ATTRIBUTES", List.of("entityid"));
        String manageUrl = String.format("%s/manage/api/internal/search/%s", this.url, EntityType.SAML20_IDP.collectionName());
        List providers = (List)this.restTemplate.postForObject(manageUrl, body, List.class, new Object[0]);
        if (providers != null) {
            LOG.debug((Object)String.format("Got %d results for idpEntityIdentifiersByServiceEntityId", providers.size()));
        }
        return providers.stream().map(m -> (String)((Map)m.get("data")).get("entityid")).toList();
    }

    public Optional<Map<String, Object>> providerByEntityID(EntityType entityType, String entityID) {
        LOG.debug((Object)String.format("providerByEntityID (%s) %s", entityType, entityID));
        String body = String.format("{\"data.entityid\":\"%s\"}", entityID);
        String manageUrl = String.format("%s/manage/api/internal/rawSearch/%s", this.url, entityType.collectionName());
        List providers = (List)this.restTemplate.postForObject(manageUrl, (Object)body, List.class, new Object[0]);
        List allProviders = this.transformProvider(providers);
        if (allProviders != null) {
            LOG.debug((Object)String.format("Got %d results for providerByEntityID", allProviders.size()));
        }
        return allProviders.isEmpty() ? Optional.empty() : Optional.of((Map)allProviders.get(0));
    }

    public Map<String, Object> providerById(EntityType entityType, String id) {
        LOG.debug((Object)String.format("providerById (%s) %s", entityType, id));
        String queryUrl = String.format("%s/manage/api/internal/metadata/%s/%s", this.url, entityType.collectionName(), id);
        return this.transformProvider((Map)this.restTemplate.getForEntity(queryUrl, Map.class, new Object[0]).getBody());
    }

    public List<Map<String, Object>> provisioning(Collection<String> applicationIdentifiers) {
        LOG.debug((Object)"provisionings for identifiers");
        if (CollectionUtils.isEmpty(applicationIdentifiers)) {
            LOG.debug((Object)"No applicationIdentifiers in provisioning");
            return Collections.emptyList();
        }
        String queryUrl = String.format("%s/manage/api/internal/provisioning", this.url);
        return this.transformProvider((List)this.restTemplate.postForObject(queryUrl, applicationIdentifiers, List.class, new Object[0]));
    }

    public List<Map<String, Object>> providersAllowedByIdPs(List<Map<String, Object>> identityProviders) {
        LOG.debug((Object)"providersAllowedByIdPs");
        if (identityProviders.isEmpty()) {
            LOG.debug((Object)"No identityProviders in providersAllowedByIdPs");
            return Collections.emptyList();
        }
        if (identityProviders.stream().anyMatch(idp -> idp.getOrDefault("allowedall", Boolean.FALSE))) {
            return this.providers(new EntityType[]{EntityType.SAML20_SP, EntityType.OIDC10_RP});
        }
        String split = identityProviders.stream().map(idp -> idp.getOrDefault("allowedEntities", Collections.emptyList())).flatMap(Collection::stream).map(m -> "\"" + (String)m.get("name") + "\"").distinct().collect(Collectors.joining(","));
        String body = String.format("{\"data.entityid\":{\"$in\":[%s]}}", split);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        List.of(EntityType.SAML20_SP, EntityType.OIDC10_RP).forEach(entityType -> {
            String manageUrl = String.format("%s/manage/api/internal/rawSearch/%s", this.url, entityType.collectionName());
            List providers = (List)this.restTemplate.postForObject(manageUrl, (Object)body, List.class, new Object[0]);
            List transformedProviders = this.transformProvider(providers);
            results.addAll(transformedProviders);
        });
        LOG.debug((Object)String.format("Got %d results for providersAllowedByIdPs", results.size()));
        return results;
    }

    public List<Map<String, Object>> providersAllowedByIdP(Map<String, Object> identityProvider) {
        LOG.debug((Object)("providersAllowedByIdP for : " + String.valueOf(identityProvider.get("type"))));
        return this.providersAllowedByIdPs(List.of(identityProvider));
    }

    public List<Map<String, Object>> identityProvidersByInstitutionalGUID(String organisationGUID) {
        LOG.debug((Object)("identityProviderByInstitutionalGUID for : " + organisationGUID));
        Map baseQuery = this.getBaseQuery();
        baseQuery.put("metaDataFields.coin:institution_guid", organisationGUID);
        List requestedAttributes = (List)baseQuery.get("REQUESTED_ATTRIBUTES");
        requestedAttributes.add("allowedEntities");
        requestedAttributes.add("allowedall");
        requestedAttributes.remove("arp");
        List identityProviders = (List)this.restTemplate.postForObject(String.format("%s/manage/api/internal/search/%s", this.url, EntityType.SAML20_IDP.collectionName()), (Object)baseQuery, List.class, new Object[0]);
        if (identityProviders != null) {
            LOG.debug((Object)String.format("Got %d results for identityProvidersByInstitutionalGUID", identityProviders.size()));
        }
        return this.transformProvider(identityProviders);
    }

    private List<Map<String, Object>> getRemoteMetaData(String type) {
        Map baseQuery = this.getBaseQuery();
        String url = String.format("%s/manage/api/internal/search/%s", this.url, type);
        return this.transformProvider((List)this.restTemplate.postForObject(url, (Object)baseQuery, List.class, new Object[0]));
    }

    private Map<String, Object> getBaseQuery() {
        HashMap<String, Object> baseQuery = new HashMap<String, Object>();
        ArrayList<String> requestedAttributes = new ArrayList<String>();
        requestedAttributes.add("arp");
        requestedAttributes.add("metaDataFields.logo:0:url");
        requestedAttributes.add("metaDataFields.coin:application_url");
        requestedAttributes.add("metaDataFields.coin:institution_guid");
        baseQuery.put("REQUESTED_ATTRIBUTES", requestedAttributes);
        return baseQuery;
    }
}

