/*
 * Decompiled with CFR 0.152.
 */
package invite.security;

import invite.config.HashGenerator;
import invite.exception.UserRestrictionException;
import invite.manage.Manage;
import invite.model.APIToken;
import invite.model.User;
import invite.repository.APITokenRepository;
import invite.repository.UserRepository;
import invite.security.SuperAdmin;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.MethodParameter;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class UserHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final UserRepository userRepository;
    private final APITokenRepository apiTokenRepository;
    private final SuperAdmin superAdmin;
    private final Manage manage;

    public UserHandlerMethodArgumentResolver(UserRepository userRepository, APITokenRepository apiTokenRepository, SuperAdmin superAdmin, Manage manage) {
        this.userRepository = userRepository;
        this.apiTokenRepository = apiTokenRepository;
        this.superAdmin = superAdmin;
        this.manage = manage;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(User.class);
    }

    public User resolveArgument(MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) {
        Map attributes;
        Principal userPrincipal = webRequest.getUserPrincipal();
        String apiTokenHeader = webRequest.getHeader("X-API-TOKEN");
        if (userPrincipal instanceof BearerTokenAuthentication) {
            BearerTokenAuthentication bearerTokenAuthentication = (BearerTokenAuthentication)userPrincipal;
            attributes = bearerTokenAuthentication.getTokenAttributes();
        } else if (userPrincipal instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken authenticationToken = (OAuth2AuthenticationToken)userPrincipal;
            attributes = authenticationToken.getPrincipal().getAttributes();
        } else {
            if (StringUtils.hasText((String)apiTokenHeader)) {
                String hashedToken = HashGenerator.hashToken((String)apiTokenHeader);
                APIToken apiToken = (APIToken)this.apiTokenRepository.findByHashedValue(hashedToken).orElseThrow(UserRestrictionException::new);
                ArrayList<User> apiUsers = new ArrayList<User>();
                User owner = apiToken.getOwner();
                String organizationGUID = apiToken.getOrganizationGUID();
                if (owner != null) {
                    apiUsers.add(apiToken.getOwner());
                } else if (StringUtils.hasText((String)organizationGUID)) {
                    apiUsers.addAll(this.userRepository.findByOrganizationGUIDAndInstitutionAdmin(organizationGUID, true));
                } else if (apiToken.isSuperUserToken()) {
                    apiUsers.addAll(this.userRepository.findBySuperUserTrue());
                }
                if (apiUsers.isEmpty()) {
                    throw new UserRestrictionException();
                }
                User user2 = (User)apiUsers.getFirst();
                if (StringUtils.hasText((String)organizationGUID)) {
                    this.addInstitutionAdminAttributes(user2, organizationGUID, Map.of());
                }
                return user2;
            }
            return null;
        }
        String sub = attributes.get("sub").toString();
        AtomicBoolean validImpersonation = new AtomicBoolean(false);
        Optional<User> optionalUser = this.userRepository.findBySubIgnoreCase(sub).or(() -> this.superAdmin.getUsers().stream().filter(adminSub -> adminSub.equals(sub)).findFirst().map(adminSub -> (User)this.userRepository.save((Object)new User(true, attributes)))).or(() -> {
            if (((Boolean)attributes.get("INSTITUTION_ADMIN")).booleanValue()) {
                User user = new User(attributes);
                this.userRepository.save((Object)user);
                return Optional.of(user);
            }
            return Optional.empty();
        }).map(user -> {
            String impersonateId = webRequest.getHeader("X-IMPERSONATE-ID");
            if (StringUtils.hasText((String)impersonateId) && user.isSuperUser()) {
                validImpersonation.set(true);
                return (User)this.userRepository.findById((Object)Long.valueOf(impersonateId)).orElseThrow(UserRestrictionException::new);
            }
            return user;
        });
        HttpServletRequest request = ((ServletWebRequest)webRequest).getRequest();
        String requestURI = request.getRequestURI();
        if (optionalUser.isEmpty() && requestURI.equals("/api/v1/users/config")) {
            return new User(attributes);
        }
        return optionalUser.map(user -> {
            if (user.isInstitutionAdmin() && StringUtils.hasText((String)user.getOrganizationGUID())) {
                String organizationGUID = user.getOrganizationGUID();
                if (validImpersonation.get()) {
                    this.addInstitutionAdminAttributes(user, organizationGUID, attributes);
                } else {
                    user.updateRemoteAttributes(attributes);
                }
            }
            return user;
        }).orElseThrow(UserRestrictionException::new);
    }

    private void addInstitutionAdminAttributes(User user, String organizationGUID, Map<String, Object> claims) {
        Map attributes = this.manage.enrichInstitutionAdmin(organizationGUID, claims);
        user.updateRemoteAttributes(attributes);
    }
}

