/*
 * Decompiled with CFR 0.152.
 */
package manage.model;

import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Version;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="scopes")
public class Scope
implements Serializable {
    @Id
    private String id;
    @Version
    private Long version;
    @NotNull
    @Indexed(unique=true)
    private String name;
    private Map<String, String> titles;
    private Map<String, String> descriptions;

    public Scope(String name, Map<String, String> titles, Map<String, String> descriptions) {
        this.name = name;
        this.titles = titles;
        this.descriptions = descriptions;
    }

    public void update(Scope scope) {
        this.titles = scope.getTitles() != null ? scope.getTitles() : new HashMap();
        this.descriptions = scope.getDescriptions() != null ? scope.getDescriptions() : new HashMap();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Long getVersion() {
        return this.version;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getTitles() {
        return this.titles;
    }

    @Generated
    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    @Generated
    public Scope() {
    }

    @Generated
    public Scope(String id, Long version, String name, Map<String, String> titles, Map<String, String> descriptions) {
        this.id = id;
        this.version = version;
        this.name = name;
        this.titles = titles;
        this.descriptions = descriptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope other = (Scope)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Scope;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Scope(id=" + this.getId() + ", version=" + this.getVersion() + ", name=" + this.getName() + ", titles=" + String.valueOf(this.getTitles()) + ", descriptions=" + String.valueOf(this.getDescriptions()) + ")";
    }
}

