/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import manage.api.AbstractUser;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;

public class EntityIdReconcilerHook
extends MetaDataHookAdapter {
    private final MetaDataRepository metaDataRepository;

    public EntityIdReconcilerHook(MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return !metaData.getType().equals(EntityType.STT.getType()) && !metaData.getType().equals(EntityType.PROV.getType());
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        String newEntityId;
        String oldEntityId = this.entityId(previous);
        if (oldEntityId.equals(newEntityId = this.entityId(newMetaData))) {
            return newMetaData;
        }
        String metaDataType = newMetaData.getType();
        List types = this.metaDataTypesForeignKeyRelations(metaDataType);
        this.getCollectionReferenceNames(metaDataType).forEach(name -> types.forEach(type -> {
            List references = this.metaDataRepository.findRaw(type, String.format("{\"data.%s.name\" : \"%s\"}", name, oldEntityId));
            String revisionNote = String.format("Updated after entityId rename of %s to %s", oldEntityId, newEntityId);
            references.forEach(metaData -> {
                List entities = metaData.getData().getOrDefault(name, new ArrayList());
                entities.stream().filter(entry -> oldEntityId.equals(entry.get("name"))).findAny().ifPresent(entry -> entry.put("name", newEntityId));
                this.revision(metaData, revisionNote);
            });
        }));
        return newMetaData;
    }

    public MetaData preDelete(MetaData metaDataToBeDeleted, AbstractUser user) {
        String entityId = this.entityId(metaDataToBeDeleted);
        String metaDataType = metaDataToBeDeleted.getType();
        List types = this.metaDataTypesForeignKeyRelations(metaDataType);
        this.getCollectionReferenceNames(metaDataType).forEach(name -> types.forEach(type -> {
            List references = this.metaDataRepository.findRaw(type, String.format("{\"data.%s.name\" : \"%s\"}", name, entityId));
            String revisionNote = String.format("Updated after deletion of entityId %s", entityId);
            references.forEach(metaData -> {
                List entities = metaData.getData().getOrDefault(name, new ArrayList());
                entities = entities.stream().filter(entry -> !entityId.equals(entry.get("name"))).collect(Collectors.toList());
                metaData.getData().put(name, entities);
                this.revision(metaData, revisionNote);
            });
        }));
        return metaDataToBeDeleted;
    }

    private String entityId(MetaData metaData) {
        return (String)metaData.getData().get("entityid");
    }

    private void revision(MetaData metaData, String revisionNote) {
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest("System", revisionNote);
        this.metaDataRepository.update(metaData);
    }

    private List<String> getCollectionReferenceNames(String type) {
        if (type.equals(EntityType.SP.getType()) || type.equals(EntityType.RP.getType())) {
            return Arrays.asList("allowedEntities", "stepupEntities", "mfaEntities", "disableConsent", "serviceProviderIds");
        }
        if (type.equals(EntityType.IDP.getType())) {
            return Arrays.asList("allowedEntities", "identityProviderIds");
        }
        if (type.equals(EntityType.RS.getType())) {
            return Collections.singletonList("allowedResourceServers");
        }
        return Collections.emptyList();
    }

    private List<String> metaDataTypesForeignKeyRelations(String type) {
        if (type.equals(EntityType.SP.getType()) || type.equals(EntityType.RP.getType())) {
            return Arrays.asList(EntityType.IDP.getType(), EntityType.PDP.getType());
        }
        if (type.equals(EntityType.IDP.getType())) {
            return Arrays.asList(EntityType.SP.getType(), EntityType.RP.getType(), EntityType.PDP.getType());
        }
        if (type.equals(EntityType.RS.getType())) {
            return Collections.singletonList(EntityType.RP.getType());
        }
        return Collections.emptyList();
    }
}

