/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import manage.api.AbstractUser;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;

public class ProvisioningApplicationDeletionHook
extends MetaDataHookAdapter {
    private final MetaDataRepository metaDataRepository;

    public ProvisioningApplicationDeletionHook(MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.RP.getType()) || metaData.getType().equals(EntityType.SP.getType());
    }

    public MetaData preDelete(MetaData metaDataToBeDeleted, AbstractUser user) {
        String id = metaDataToBeDeleted.getId();
        String metaDataType = metaDataToBeDeleted.getType();
        List references = this.metaDataRepository.findRaw(EntityType.PROV.getType(), String.format("{$and:[{\"data.applications.id\" : \"%s\"},{\"data.applications.type\" : \"%s\"}]}", id, metaDataType));
        String revisionNote = String.format("Updated after deletion of entityId %s", this.entityId(metaDataToBeDeleted));
        references.forEach(metaData -> {
            List entities = metaData.getData().getOrDefault("applications", new ArrayList());
            entities = entities.stream().filter(entry -> !id.equals(entry.get("id")) || !metaDataType.equals(entry.get("type"))).collect(Collectors.toList());
            metaData.getData().put("applications", entities);
            this.revision(metaData, revisionNote);
        });
        return metaDataToBeDeleted;
    }

    private String entityId(MetaData metaData) {
        return (String)metaData.getData().get("entityid");
    }

    private void revision(MetaData metaData, String revisionNote) {
        String id = metaData.getId();
        MetaData previous = this.metaDataRepository.findById(id, metaData.getType());
        previous.revision(UUID.randomUUID().toString());
        this.metaDataRepository.save(previous);
        metaData.promoteToLatest("System", revisionNote);
        this.metaDataRepository.update(metaData);
    }
}

