/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import manage.exception.CustomValidationException;
import manage.exception.ScopeInUseException;
import org.everit.json.schema.ValidationException;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
public class ErrorController
implements org.springframework.boot.web.servlet.error.ErrorController {
    private final ErrorAttributes errorAttributes = new DefaultErrorAttributes();

    @RequestMapping(value={"/error"})
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus statusCode;
        HttpStatus status;
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Map result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.defaults());
        Throwable error = this.errorAttributes.getError((WebRequest)webRequest);
        boolean isInternalCall = StringUtils.hasText((String)request.getHeader("Authorization"));
        HttpStatus httpStatus = status = isInternalCall ? HttpStatus.BAD_REQUEST : HttpStatus.OK;
        if (error instanceof CustomValidationException) {
            ValidationException validationException = ((CustomValidationException)CustomValidationException.class.cast(error)).getValidationException();
            return ErrorController.validationExceptionResponse((Map)result, (ValidationException)validationException, (HttpStatus)status);
        }
        if (error instanceof ValidationException) {
            ValidationException validationException = (ValidationException)((Object)ValidationException.class.cast(error));
            return ErrorController.validationExceptionResponse((Map)result, (ValidationException)validationException, (HttpStatus)status);
        }
        if (error instanceof OptimisticLockingFailureException) {
            result.put("validations", "Optimistic locking failure e.g. mid-air collision. Refresh your screen to get the latest version.");
            result.put("status", status.value());
            result.put("error", OptimisticLockingFailureException.class.getName());
            return new ResponseEntity((Object)result, (HttpStatusCode)status);
        }
        if (error instanceof HttpClientErrorException) {
            HttpClientErrorException httpClientErrorException = (HttpClientErrorException)error;
            result.put("status", httpClientErrorException.getStatusCode().toString());
            result.put("error", HttpClientErrorException.class.getName());
            result.put("message", httpClientErrorException.getResponseBodyAsString());
            return new ResponseEntity((Object)result, (HttpStatusCode)status);
        }
        if (error instanceof ScopeInUseException) {
            result.put("message", error.getMessage());
        }
        HttpStatus httpStatus2 = statusCode = result.containsKey("status") ? HttpStatus.valueOf((int)((Integer)result.get("status"))) : HttpStatus.INTERNAL_SERVER_ERROR;
        if (error != null) {
            ResponseStatus annotation = (ResponseStatus)AnnotationUtils.getAnnotation(error.getClass(), ResponseStatus.class);
            statusCode = annotation != null ? annotation.value() : statusCode;
            result.put("exception", error.getClass().getCanonicalName());
        }
        return new ResponseEntity((Object)result, (HttpStatusCode)statusCode);
    }

    private static ResponseEntity<Map<String, Object>> validationExceptionResponse(Map<String, Object> result, ValidationException validationException, HttpStatus status) {
        result.put("validations", String.join((CharSequence)", ", validationException.getAllMessages()));
        result.put("status", status.value());
        result.put("error", ValidationException.class.getName());
        return new ResponseEntity(result, (HttpStatusCode)status);
    }
}

