/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import manage.model.MetaData;
import manage.model.Revision;
import manage.policies.CidrNotation;
import manage.policies.LoA;
import manage.policies.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PdpPolicyDefinition {
    private String id;
    private String policyId;
    private String name;
    private String description;
    private List<String> serviceProviderIds = new ArrayList();
    private List<String> serviceProviderNames = new ArrayList();
    private List<String> serviceProviderNamesNl = new ArrayList();
    private List<String> identityProviderIds = new ArrayList();
    private List<String> identityProviderNames = new ArrayList();
    private List<String> identityProviderNamesNl = new ArrayList();
    private String clientId;
    private List<PdpAttribute> attributes = new ArrayList();
    private List<LoA> loas = new ArrayList();
    private boolean denyRule;
    private boolean allAttributesMustMatch;
    private Instant created;
    private String userDisplayName;
    private String authenticatingAuthorityName;
    private String denyAdvice;
    private String denyAdviceNl;
    private boolean isActivatedSr;
    private boolean active;
    private boolean actionsAllowed;
    private String type;
    private int revisionNbr;

    public PdpPolicyDefinition(MetaData metaData) {
        this.id = metaData.getId();
        Map data = metaData.getData();
        this.name = (String)data.get("name");
        this.description = (String)data.get("description");
        this.serviceProviderIds = this.convertProviders(data, "serviceProviderIds");
        this.identityProviderIds = this.convertProviders(data, "identityProviderIds");
        this.attributes = ((List)data.getOrDefault("attributes", new ArrayList())).stream().map(m -> new PdpAttribute((String)m.get("name"), (String)m.get("value"), m.getOrDefault("negated", false).booleanValue())).collect(Collectors.toList());
        this.loas = ((List)data.getOrDefault("loas", new ArrayList())).stream().map(m -> {
            List loaAttributes = m.getOrDefault("attributes", new ArrayList());
            return new LoA((String)m.get("level"), m.getOrDefault("allAttributesMustMatch", false).booleanValue(), m.getOrDefault("negateCidrNotation", false).booleanValue(), loaAttributes.stream().map(attr -> new PdpAttribute((String)attr.get("name"), (String)attr.get("value"), attr.getOrDefault("negated", false).booleanValue())).collect(Collectors.toList()), ((List)m.getOrDefault("cidrNotations", new ArrayList())).stream().map(cidr -> new CidrNotation((String)cidr.get("ipAddress"), (Integer)cidr.get("prefix"))).collect(Collectors.toList()));
        }).collect(Collectors.toList());
        this.denyRule = data.getOrDefault("denyRule", false);
        this.allAttributesMustMatch = data.getOrDefault("allAttributesMustMatch", false);
        this.userDisplayName = (String)data.get("userDisplayName");
        this.authenticatingAuthorityName = (String)data.get("authenticatingAuthorityName");
        this.denyAdvice = (String)data.get("denyAdvice");
        this.denyAdviceNl = (String)data.get("denyAdviceNl");
        this.policyId = (String)data.get("policyId");
        this.active = data.getOrDefault("active", false);
        this.type = (String)data.get("type");
        Revision revision = metaData.getRevision();
        this.created = revision.getCreated();
        this.revisionNbr = revision.getNumber();
    }

    private List<String> convertProviders(Map<String, Object> data, String name) {
        return ((List)data.get(name)).stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
    }

    public static void updateProviderStructure(Map<String, Object> data) {
        List.of("identityProviderIds", "serviceProviderIds").forEach(reference -> {
            List names = data.getOrDefault(reference, new ArrayList());
            data.put((String)reference, names.stream().map(name -> new HashMap<String, String>(Map.of("name", name))).collect(Collectors.toList()));
        });
        data.put("metaDataFields", new HashMap());
        List.of("id", "created").forEach(name -> data.remove(name));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getPolicyId() {
        return this.policyId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getServiceProviderIds() {
        return this.serviceProviderIds;
    }

    @Generated
    public List<String> getServiceProviderNames() {
        return this.serviceProviderNames;
    }

    @Generated
    public List<String> getServiceProviderNamesNl() {
        return this.serviceProviderNamesNl;
    }

    @Generated
    public List<String> getIdentityProviderIds() {
        return this.identityProviderIds;
    }

    @Generated
    public List<String> getIdentityProviderNames() {
        return this.identityProviderNames;
    }

    @Generated
    public List<String> getIdentityProviderNamesNl() {
        return this.identityProviderNamesNl;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<LoA> getLoas() {
        return this.loas;
    }

    @Generated
    public boolean isDenyRule() {
        return this.denyRule;
    }

    @Generated
    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public String getAuthenticatingAuthorityName() {
        return this.authenticatingAuthorityName;
    }

    @Generated
    public String getDenyAdvice() {
        return this.denyAdvice;
    }

    @Generated
    public String getDenyAdviceNl() {
        return this.denyAdviceNl;
    }

    @Generated
    public boolean isActivatedSr() {
        return this.isActivatedSr;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public boolean isActionsAllowed() {
        return this.actionsAllowed;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public int getRevisionNbr() {
        return this.revisionNbr;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setServiceProviderIds(List<String> serviceProviderIds) {
        this.serviceProviderIds = serviceProviderIds;
    }

    @Generated
    public void setServiceProviderNames(List<String> serviceProviderNames) {
        this.serviceProviderNames = serviceProviderNames;
    }

    @Generated
    public void setServiceProviderNamesNl(List<String> serviceProviderNamesNl) {
        this.serviceProviderNamesNl = serviceProviderNamesNl;
    }

    @Generated
    public void setIdentityProviderIds(List<String> identityProviderIds) {
        this.identityProviderIds = identityProviderIds;
    }

    @Generated
    public void setIdentityProviderNames(List<String> identityProviderNames) {
        this.identityProviderNames = identityProviderNames;
    }

    @Generated
    public void setIdentityProviderNamesNl(List<String> identityProviderNamesNl) {
        this.identityProviderNamesNl = identityProviderNamesNl;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setLoas(List<LoA> loas) {
        this.loas = loas;
    }

    @Generated
    public void setDenyRule(boolean denyRule) {
        this.denyRule = denyRule;
    }

    @Generated
    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    @Generated
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setAuthenticatingAuthorityName(String authenticatingAuthorityName) {
        this.authenticatingAuthorityName = authenticatingAuthorityName;
    }

    @Generated
    public void setDenyAdvice(String denyAdvice) {
        this.denyAdvice = denyAdvice;
    }

    @Generated
    public void setDenyAdviceNl(String denyAdviceNl) {
        this.denyAdviceNl = denyAdviceNl;
    }

    @Generated
    public void setActivatedSr(boolean isActivatedSr) {
        this.isActivatedSr = isActivatedSr;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setActionsAllowed(boolean actionsAllowed) {
        this.actionsAllowed = actionsAllowed;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setRevisionNbr(int revisionNbr) {
        this.revisionNbr = revisionNbr;
    }

    @Generated
    public PdpPolicyDefinition() {
    }
}

