/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class Provider {
    private final String entityId;
    private final String institutionId;
    private final boolean allowedAll;
    private final List<String> allowedEntityIds;

    public Provider(Map<String, Object> metaData) {
        Map data = (Map)metaData.get("data");
        this.entityId = (String)data.get("entityid");
        this.allowedEntityIds = ((List)data.getOrDefault("allowedEntities", new ArrayList())).stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
        Map metaDataFields = (Map)data.get("metaDataFields");
        this.institutionId = (String)metaDataFields.get("coin:institution_id");
        this.allowedAll = (Boolean)metaData.getOrDefault("allowedall", false);
    }

    public boolean isAllowedFrom(String ... entityIds) {
        return this.isAllowedAll() || Arrays.stream(entityIds).anyMatch(entityId -> this.getAllowedEntityIds().contains(entityId));
    }

    @Generated
    public String getEntityId() {
        return this.entityId;
    }

    @Generated
    public String getInstitutionId() {
        return this.institutionId;
    }

    @Generated
    public boolean isAllowedAll() {
        return this.allowedAll;
    }

    @Generated
    public List<String> getAllowedEntityIds() {
        return this.allowedEntityIds;
    }
}

