/*
 * Decompiled with CFR 0.152.
 */
package manage.web;

import java.net.URL;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.hc.core5.http.HttpHost;
import org.springframework.util.StringUtils;

public class HttpHostProvider {
    private HttpHostProvider() {
    }

    public static Optional<HttpHost> resolveHttpHost(URL url) {
        String proxyHost = System.getProperty("http.proxyHost");
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        boolean ignoreProxy = false;
        if (StringUtils.hasText((String)nonProxyHosts)) {
            String host = url.getHost();
            ignoreProxy = Stream.of(nonProxyHosts.split("\\|")).map(String::trim).anyMatch(nonProxyHost -> FilenameUtils.wildcardMatch((String)host, (String)nonProxyHost));
        }
        if (StringUtils.hasText((String)proxyHost) && !ignoreProxy) {
            String proxyPortString = System.getProperty("http.proxyPort");
            int proxyPort = StringUtils.hasText((String)proxyPortString) ? Integer.parseInt(proxyPortString) : 80;
            return Optional.of(new HttpHost(proxyHost, proxyPort));
        }
        return Optional.empty();
    }
}

