/*
 * Decompiled with CFR 0.152.
 */
package manage.control;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import manage.model.MetaData;
import manage.policies.PdpPolicyDefinition;
import manage.repository.MetaDataRepository;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class PdPController {
    private final String decideUrl;
    private final RestTemplate pdpRestTemplate;
    private final MetaDataRepository metaDataRepository;
    private final HttpHeaders headers;
    private final String parseUrl;

    public PdPController(@Value(value="${push.pdp.decide_url}") String decideUrl, @Value(value="${push.pdp.parse_url}") String parseUrl, @Value(value="${push.pdp.user}") String pdpUser, @Value(value="${push.pdp.password}") String pdpPassword, MetaDataRepository metaDataRepository) {
        this.decideUrl = decideUrl;
        this.parseUrl = parseUrl;
        this.metaDataRepository = metaDataRepository;
        this.pdpRestTemplate = new RestTemplate();
        this.pdpRestTemplate.getInterceptors().add(new BasicAuthenticationInterceptor(pdpUser, pdpPassword));
        this.headers = new HttpHeaders();
        this.headers.add("Content-Type", "application/json");
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/decide"})
    public String decideManage(@RequestBody String payload) {
        HttpEntity requestEntity = new HttpEntity((Object)payload, (MultiValueMap)this.headers);
        return (String)this.pdpRestTemplate.exchange(this.decideUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'READ')")
    @GetMapping(value={"/client/pdp/missing-enforcements", "/internal/pdp/missing-enforcements"})
    public List<MetaData> policiesWithMissingPolicyEnforcementDecisionRequired() {
        return this.metaDataRepository.policiesWithMissingPolicyEnforcementDecisionRequired();
    }

    @PreAuthorize(value="hasRole('ADMIN')")
    @PostMapping(value={"/client/pdp/parse"})
    public Map<String, String> xml(@RequestBody Map<String, Object> data) {
        MetaData metaData = new MetaData("policy", data);
        metaData.initial(UUID.randomUUID().toString(), "system", Long.valueOf(1L));
        PdpPolicyDefinition policyDefinition = new PdpPolicyDefinition(metaData);
        HttpEntity requestEntity = new HttpEntity((Object)policyDefinition, (MultiValueMap)this.headers);
        String res = (String)this.pdpRestTemplate.exchange(this.parseUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
        return Map.of("xml", res);
    }
}

