/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import manage.api.APIUser;
import manage.api.ImpersonatedUser;
import manage.exception.EndpointNotAllowed;
import manage.model.EntityType;
import manage.policies.PdpPolicyDefinition;
import manage.policies.PolicyAccess;
import manage.policies.PolicyIdpAccessEnforcer;
import manage.policies.Provider;
import manage.service.MetaDataService;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PolicyIdpAccessEnforcer {
    private static final List<String> requiredAttributes = List.of("metaDataFields.coin:institution_id", "entityid", "allowedall", "allowedEntities");
    private final MetaDataService metaDataService;

    public PolicyIdpAccessEnforcer(MetaDataService metaDataService) {
        this.metaDataService = metaDataService;
    }

    public boolean actionAllowed(PdpPolicyDefinition policy, PolicyAccess policyAccess, APIUser apiUser, boolean throwException) {
        ImpersonatedUser impersonatedUser = apiUser.getImpersonatedUser();
        if (impersonatedUser == null) {
            if (throwException) {
                throw new EndpointNotAllowed("ImpersonatedUser is null for apiUser: " + apiUser.getName());
            }
            return false;
        }
        String idpEntityId = impersonatedUser.getIdpEntityId();
        List userIdentityProviders = this.getUserIdentityProviders(idpEntityId);
        List userServiceProviders = this.getUserServiceProviders(userIdentityProviders);
        return this.doInternalActionAllowed(policy, policyAccess, throwException, userIdentityProviders, userServiceProviders, impersonatedUser);
    }

    private boolean doInternalActionAllowed(PdpPolicyDefinition policy, PolicyAccess policyAccess, boolean throwException, List<Provider> userIdentityProviders, List<Provider> userServiceProviders, ImpersonatedUser impersonatedUser) {
        Set userIdentityProvidersEntityIds = userIdentityProviders.stream().map(Provider::getEntityId).collect(Collectors.toSet());
        Set userServiceProvidersEntityIds = userServiceProviders.stream().map(Provider::getEntityId).collect(Collectors.toSet());
        List policyServiceProviderIds = policy.getServiceProviderIds();
        List policyIdentityProviderIds = policy.getIdentityProviderIds();
        if (CollectionUtils.isEmpty((Collection)policyIdentityProviderIds)) {
            switch (1.$SwitchMap$manage$policies$PolicyAccess[policyAccess.ordinal()]) {
                case 1: {
                    if (this.idpIsAllowed(userIdentityProviders, policyServiceProviderIds)) break;
                    if (throwException) {
                        throw new EndpointNotAllowed(String.format("Policy for target SP '%s' requested by '%s', but this SP is not allowed access by users from IdP '%s'", policyServiceProviderIds, impersonatedUser.getUnspecifiedNameId(), impersonatedUser.getIdpEntityId()));
                    }
                    return false;
                }
                case 2: {
                    if (userServiceProvidersEntityIds.containsAll(policyServiceProviderIds)) break;
                    if (throwException) {
                        throw new EndpointNotAllowed(String.format("Policy for target SP '%s' requested by '%s', but this SP is not owned to users IdP '%s'", policyServiceProviderIds, impersonatedUser.getUnspecifiedNameId(), impersonatedUser.getIdpEntityId()));
                    }
                    return false;
                }
            }
        } else if (!userIdentityProvidersEntityIds.containsAll(policyIdentityProviderIds)) {
            if (throwException) {
                throw new EndpointNotAllowed(String.format("Policy for target IdPs '%s' requested by '%s', but not all are linked to users IdP '%s", policyIdentityProviderIds, impersonatedUser.getUnspecifiedNameId(), impersonatedUser.getIdpEntityId()));
            }
            return false;
        }
        if (policyAccess.equals((Object)PolicyAccess.READ)) {
            return true;
        }
        String authenticatingAuthorityName = policy.getAuthenticatingAuthorityName();
        if (userIdentityProvidersEntityIds.contains(authenticatingAuthorityName)) {
            return true;
        }
        if (throwException) {
            throw new EndpointNotAllowed(String.format("Policy created by admin '%s' of IdP '%s' can not be updated / deleted by admin '%s' of IdP '%s'", policy.getUserDisplayName(), authenticatingAuthorityName, impersonatedUser.getUnspecifiedNameId(), impersonatedUser.getIdpEntityId()));
        }
        return false;
    }

    public List<PdpPolicyDefinition> filterPdpPolicies(APIUser apiUser, List<PdpPolicyDefinition> policies) {
        ImpersonatedUser impersonatedUser = apiUser.getImpersonatedUser();
        if (impersonatedUser == null) {
            return Collections.emptyList();
        }
        String idpEntityId = impersonatedUser.getIdpEntityId();
        List userIdentityProviders = this.getUserIdentityProviders(idpEntityId);
        List userServiceProviders = this.getUserServiceProviders(userIdentityProviders);
        Set userServiceProviderIds = userServiceProviders.stream().map(Provider::getEntityId).collect(Collectors.toSet());
        List<PdpPolicyDefinition> pdpPolicyDefinitions = policies.stream().filter(policy -> this.maySeePolicy(policy, userIdentityProviders, userServiceProviderIds)).collect(Collectors.toList());
        pdpPolicyDefinitions.forEach(policy -> policy.setActionsAllowed(this.doInternalActionAllowed(policy, PolicyAccess.WRITE, false, userIdentityProviders, userServiceProviders, impersonatedUser)));
        return pdpPolicyDefinitions;
    }

    private boolean maySeePolicy(PdpPolicyDefinition pdpPolicyDefinition, List<Provider> userIdentityProviders, Set<String> userServiceProviderIds) {
        Set userIdentityProvidersIds = userIdentityProviders.stream().map(Provider::getEntityId).collect(Collectors.toSet());
        List policyIdentityProviderIds = pdpPolicyDefinition.getIdentityProviderIds();
        List policyServiceProviderIds = pdpPolicyDefinition.getServiceProviderIds();
        if (CollectionUtils.isEmpty((Collection)policyIdentityProviderIds)) {
            return this.idpIsAllowed(userIdentityProviders, policyServiceProviderIds) || policyServiceProviderIds.stream().anyMatch(spId -> userServiceProviderIds.contains(spId));
        }
        return policyIdentityProviderIds.stream().anyMatch(idp -> userIdentityProvidersIds.contains(idp));
    }

    private boolean idpIsAllowed(List<Provider> userIdentityProviders, List<String> serviceProviderIds) {
        return userIdentityProviders.stream().anyMatch(idp -> idp.isAllowedFrom(serviceProviderIds.toArray(new String[0])));
    }

    private List<Provider> getUserIdentityProviders(String entityId) {
        EntityType entityType = EntityType.IDP;
        HashMap<String, Object> searchOptions = new HashMap<String, Object>();
        searchOptions.put("REQUESTED_ATTRIBUTES", requiredAttributes);
        searchOptions.put("entityid", entityId);
        List<Object> providers = this.metaDataService.searchEntityByType(entityType.getType(), searchOptions, false).stream().map(entity -> new Provider(entity)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(providers)) {
            return Collections.emptyList();
        }
        List institutionIds = providers.stream().map(provider -> provider.getInstitutionId()).filter(institutionId -> StringUtils.hasText((String)institutionId)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(institutionIds)) {
            searchOptions = new HashMap();
            searchOptions.put("REQUESTED_ATTRIBUTES", requiredAttributes);
            searchOptions.put("metaDataFields.coin:institution_id", institutionIds);
            providers = this.metaDataService.searchEntityByType(entityType.getType(), searchOptions, false).stream().map(entity -> new Provider(entity)).collect(Collectors.toList());
        }
        return providers;
    }

    private List<Provider> getUserServiceProviders(List<Provider> userIdentityProviders) {
        if (CollectionUtils.isEmpty(userIdentityProviders)) {
            return Collections.emptyList();
        }
        EntityType entityType = EntityType.SP;
        HashMap<String, Object> searchOptions = new HashMap<String, Object>();
        searchOptions.put("REQUESTED_ATTRIBUTES", requiredAttributes);
        searchOptions.put("metaDataFields.coin:institution_id", userIdentityProviders.get(0).getInstitutionId());
        return this.metaDataService.searchEntityByType(entityType.getType(), searchOptions, false).stream().map(entity -> new Provider(entity)).collect(Collectors.toList());
    }
}

