/*
 * Decompiled with CFR 0.152.
 */
package manage.service.jobs;

import com.mongodb.DuplicateKeyException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import lombok.Generated;
import manage.service.jobs.ClusterLock;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class ClusterLockService {
    private final MongoTemplate mongoTemplate;
    private final String nodeId = UUID.randomUUID().toString();

    public ClusterLockService(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public boolean tryAcquire(String lockName, int ttlSeconds) {
        Instant expiresAt = Instant.now().plus((long)ttlSeconds, ChronoUnit.SECONDS);
        ClusterLock lock = new ClusterLock(lockName, this.nodeId, expiresAt);
        try {
            this.mongoTemplate.insert((Object)lock);
            return true;
        }
        catch (DuplicateKeyException e) {
            return false;
        }
    }

    public void release(String lockName) {
        this.mongoTemplate.remove(this.mongoTemplate.findById((Object)lockName, ClusterLock.class));
    }

    @Generated
    public String getNodeId() {
        return this.nodeId;
    }
}

