/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import crypto.HybridRSAKeyStore;
import crypto.KeyStore;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.CompositeMetaDataHook;
import manage.hook.EmptyRevisionHook;
import manage.hook.EncryptionHook;
import manage.hook.EntityIdConstraintsHook;
import manage.hook.EntityIdDuplicationHook;
import manage.hook.EntityIdReconcilerHook;
import manage.hook.ExtraneousKeysPoliciesHook;
import manage.hook.IdentityProviderBrinCodeHook;
import manage.hook.IdentityProviderDeleteHook;
import manage.hook.OidcValidationHook;
import manage.hook.OrganisationDeletionHook;
import manage.hook.PolicyNameConstraintsHook;
import manage.hook.PolicyValidationHook;
import manage.hook.ProvisioningApplicationDeletionHook;
import manage.hook.ProvisioningHook;
import manage.hook.RequiredAttributesHook;
import manage.hook.SSIDValidationHook;
import manage.hook.SecretHook;
import manage.hook.SecurityHook;
import manage.hook.ServiceProviderDeleteHook;
import manage.hook.TypeSafetyHook;
import manage.repository.MetaDataRepository;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class MetaDataHookConfiguration {
    @Bean
    CompositeMetaDataHook hooks(MetaDataRepository metaDataRepository, MetaDataAutoConfiguration metaDataAutoConfiguration, @Value(value="${crypto.public-key-location}") Resource publicKeyResource, @Value(value="${crypto.development-mode}") Boolean developmentMode, @Value(value="${crypto.enabled}") boolean cryptoEnabled, @Value(value="${feature_toggles.allow_secret_public_rp}") boolean allowSecretPublicRP) {
        HybridRSAKeyStore keyStore = developmentMode != false ? new HybridRSAKeyStore() : new HybridRSAKeyStore(IOUtils.toString((InputStream)publicKeyResource.getInputStream(), (Charset)Charset.defaultCharset()), true);
        return new CompositeMetaDataHook(Arrays.asList(new SecurityHook(), new EmptyRevisionHook(metaDataAutoConfiguration), new EntityIdDuplicationHook(metaDataAutoConfiguration, metaDataRepository), new IdentityProviderDeleteHook(metaDataAutoConfiguration, metaDataRepository), new ServiceProviderDeleteHook(metaDataAutoConfiguration, metaDataRepository), new PolicyNameConstraintsHook(metaDataAutoConfiguration, metaDataRepository), new PolicyValidationHook(metaDataAutoConfiguration), new ExtraneousKeysPoliciesHook(metaDataAutoConfiguration), new OidcValidationHook(metaDataAutoConfiguration, allowSecretPublicRP), new TypeSafetyHook(metaDataAutoConfiguration), new EntityIdConstraintsHook(metaDataRepository), new EntityIdReconcilerHook(metaDataRepository), new SSIDValidationHook(metaDataRepository, metaDataAutoConfiguration), new SecretHook(metaDataAutoConfiguration), new RequiredAttributesHook(metaDataAutoConfiguration), new ProvisioningHook(metaDataRepository, metaDataAutoConfiguration), new EncryptionHook((KeyStore)keyStore, cryptoEnabled), new ProvisioningApplicationDeletionHook(metaDataRepository), new IdentityProviderBrinCodeHook(metaDataAutoConfiguration), new OrganisationDeletionHook(metaDataRepository, metaDataAutoConfiguration)));
    }
}

