/*
 * Decompiled with CFR 0.152.
 */
package manage.policies;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import manage.api.APIUser;
import manage.api.AbstractUser;
import manage.api.ImpersonatedUser;
import manage.control.DatabaseController;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.model.PushOptions;
import manage.policies.IPAddressProvider;
import manage.policies.PdpPolicyDefinition;
import manage.policies.PolicyAccess;
import manage.policies.PolicyIdpAccessEnforcer;
import manage.repository.MetaDataRepository;
import manage.service.MetaDataService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PolicyController {
    private final MetaDataService metaDataService;
    private final ObjectMapper objectMapper;
    private final PolicyIdpAccessEnforcer policyIdpAccessEnforcer;
    private final MetaDataRepository metaDataRepository;
    private final List<Map<String, Object>> allowedAttributes;
    private final List<Map<String, Object>> samlAllowedAttributes;
    private final List<String> loaLevels;
    private final DatabaseController databaseController;
    private final TypeReference<List<Map<String, Object>>> typeReference = new /* Unavailable Anonymous Inner Class!! */;

    public PolicyController(MetaDataService metaDataService, ObjectMapper objectMapper, PolicyIdpAccessEnforcer policyIdpAccessEnforcer, MetaDataRepository metaDataRepository, DatabaseController databaseController, @Value(value="${policies.allowed_attributes}") Resource allowedAttributesResource, @Value(value="${policies.extra_saml_attributes}") Resource extraSamlAttributesResource, @Value(value="${loa_levels}") String loaLevelsCommaSeparated) {
        this.metaDataService = metaDataService;
        this.objectMapper = objectMapper;
        this.policyIdpAccessEnforcer = policyIdpAccessEnforcer;
        this.metaDataRepository = metaDataRepository;
        this.databaseController = databaseController;
        this.allowedAttributes = this.attributes(allowedAttributesResource);
        this.allowedAttributes.sort(Comparator.comparing(o -> (String)o.get("label")));
        this.samlAllowedAttributes = this.attributes(extraSamlAttributesResource);
        this.samlAllowedAttributes.addAll(this.allowedAttributes);
        this.samlAllowedAttributes.sort(Comparator.comparing(o -> (String)o.get("label")));
        this.loaLevels = Stream.of(loaLevelsCommaSeparated.split(",")).map(String::trim).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @GetMapping(value={"/internal/protected/policies"})
    public List<PdpPolicyDefinition> policies(APIUser apiUser) {
        List policies = this.metaDataService.findAllByType(EntityType.PDP.getType()).stream().map(metaData -> new PdpPolicyDefinition(metaData)).collect(Collectors.toList());
        return this.policyIdpAccessEnforcer.filterPdpPolicies(apiUser, policies).stream().map(policy -> this.enrichPolicyDefinition(policy)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @GetMapping(value={"/internal/protected/policies/{id}"})
    public PdpPolicyDefinition policies(APIUser apiUser, @PathVariable(value="id") String id) {
        PdpPolicyDefinition policy;
        boolean actionsAllowed = this.policyIdpAccessEnforcer.actionAllowed(policy = new PdpPolicyDefinition(this.metaDataService.getMetaDataAndValidate(EntityType.PDP.getType(), id)), PolicyAccess.READ, apiUser, true);
        policy.setActionsAllowed(actionsAllowed && !policy.getType().equals("step"));
        return this.enrichPolicyDefinition(policy);
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @PostMapping(value={"/internal/protected/policies"})
    public PdpPolicyDefinition create(APIUser apiUser, @RequestBody PdpPolicyDefinition policyDefinition) {
        this.initialPolicyValues(apiUser, policyDefinition, true);
        this.policyIdpAccessEnforcer.actionAllowed(policyDefinition, PolicyAccess.WRITE, apiUser, true);
        Map data = (Map)this.objectMapper.convertValue((Object)policyDefinition, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        PdpPolicyDefinition.updateProviderStructure((Map)data);
        MetaData metaData = new MetaData(EntityType.PDP.getType(), data);
        MetaData metaDataSaved = this.metaDataService.doPost(metaData, (AbstractUser)apiUser, false);
        policyDefinition.setId(metaDataSaved.getId());
        this.databaseController.doPush(new PushOptions(false, false, true));
        return policyDefinition;
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @PutMapping(value={"/internal/protected/policies"})
    public PdpPolicyDefinition update(APIUser apiUser, @RequestBody PdpPolicyDefinition policyDefinition) throws JsonProcessingException {
        this.initialPolicyValues(apiUser, policyDefinition, false);
        MetaData existingMetaData = this.metaDataService.getMetaDataAndValidate(EntityType.PDP.getType(), policyDefinition.getId());
        String authenticatingAuthorityName = (String)existingMetaData.getData().get("authenticatingAuthorityName");
        policyDefinition.setAuthenticatingAuthorityName(authenticatingAuthorityName);
        this.policyIdpAccessEnforcer.actionAllowed(policyDefinition, PolicyAccess.WRITE, apiUser, true);
        Map data = (Map)this.objectMapper.convertValue((Object)policyDefinition, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        PdpPolicyDefinition.updateProviderStructure((Map)data);
        existingMetaData.setData(data);
        MetaData metaData = this.metaDataService.doPut(existingMetaData, (AbstractUser)apiUser, false);
        policyDefinition.setRevisionNbr(metaData.getRevision().getNumber());
        this.databaseController.doPush(new PushOptions(false, false, true));
        return policyDefinition;
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @DeleteMapping(value={"/internal/protected/policies/{id}"})
    public void delete(APIUser apiUser, @PathVariable(value="id") String id) {
        PdpPolicyDefinition policyDefinition = new PdpPolicyDefinition(this.metaDataService.getMetaDataAndValidate(EntityType.PDP.getType(), id));
        this.initialPolicyValues(apiUser, policyDefinition, false);
        this.policyIdpAccessEnforcer.actionAllowed(policyDefinition, PolicyAccess.WRITE, apiUser, true);
        this.metaDataService.doRemove(EntityType.PDP.getType(), id, (AbstractUser)apiUser, "Deleted by dashboard API");
        this.databaseController.doPush(new PushOptions(false, false, true));
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @GetMapping(value={"/internal/protected/revisions/{id}"})
    public List<PdpPolicyDefinition> revisions(APIUser apiUser, @PathVariable(value="id") String id) {
        String type = EntityType.PDP.getType();
        PdpPolicyDefinition policy = new PdpPolicyDefinition(this.metaDataService.getMetaDataAndValidate(type, id));
        this.policyIdpAccessEnforcer.actionAllowed(policy, PolicyAccess.READ, apiUser, true);
        List revisions = this.metaDataRepository.revisions(type.concat("_revision"), id);
        ArrayList<PdpPolicyDefinition> pdpPolicyDefinitionRevisions = new ArrayList<PdpPolicyDefinition>(revisions.stream().map(revision -> this.enrichPolicyDefinition(new PdpPolicyDefinition(revision))).collect(Collectors.toList()));
        pdpPolicyDefinitionRevisions.add(policy);
        return pdpPolicyDefinitionRevisions;
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'POLICIES')")
    @RequestMapping(method={RequestMethod.GET}, value={"/client/attributes", "/internal/protected/allowed-attributes"})
    public List<Map<String, Object>> getAllowedAttributes() {
        return this.allowedAttributes;
    }

    @PreAuthorize(value="hasRole('POLICIES')")
    @RequestMapping(method={RequestMethod.GET}, value={"/internal/protected/attributes", "/internal/protected/attributes/"})
    public List<Map<String, Object>> getAllowedAttributesForDashboard() {
        return this.allowedAttributes.stream().map(attr -> Map.of("AttributeId", attr.get("value"), "Value", attr.get("label"))).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasAnyRole('ADMIN', 'POLICIES')")
    @RequestMapping(method={RequestMethod.GET}, value={"/client/saml-attributes", "/internal/protected/saml-attributes"})
    public List<Map<String, Object>> getAllowedSamlAttributes() {
        return this.samlAllowedAttributes;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/client/loas"})
    public List<String> allowedLevelOfAssurances() {
        return this.loaLevels;
    }

    private PdpPolicyDefinition enrichPolicyDefinition(PdpPolicyDefinition policyDefinition) {
        List identityProviderIds;
        List serviceProviderIds = policyDefinition.getServiceProviderIds();
        if (!CollectionUtils.isEmpty((Collection)serviceProviderIds)) {
            HashMap properties = new HashMap();
            properties.put("entityid", serviceProviderIds);
            List serviceProviders = this.metaDataService.searchEntityByType(EntityType.SP.getType(), properties, false);
            if (serviceProviders.size() < serviceProviderIds.size()) {
                List allEntityIDs = serviceProviders.stream().map(entity -> this.entityID(entity)).collect(Collectors.toList());
                List rpProviderIds = serviceProviderIds.stream().filter(id -> !allEntityIDs.contains(id)).collect(Collectors.toList());
                properties.put("entityid", rpProviderIds);
                List relyingParties = this.metaDataService.searchEntityByType(EntityType.RP.getType(), properties, false);
                serviceProviders.addAll(relyingParties);
            }
            policyDefinition.setServiceProviderNames(serviceProviders.stream().map(sp -> this.name(sp)).collect(Collectors.toList()));
            policyDefinition.setServiceProviderNamesNl(serviceProviders.stream().map(sp -> this.nameNL(sp)).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty((Collection)(identityProviderIds = policyDefinition.getIdentityProviderIds()))) {
            HashMap<String, List> properties = new HashMap<String, List>();
            properties.put("entityid", identityProviderIds);
            List identityProviders = this.metaDataService.searchEntityByType(EntityType.IDP.getType(), properties, false);
            policyDefinition.setIdentityProviderNames(identityProviders.stream().map(idp -> this.name(idp)).collect(Collectors.toList()));
            policyDefinition.setIdentityProviderNamesNl(identityProviders.stream().map(idp -> this.nameNL(idp)).collect(Collectors.toList()));
        }
        if (policyDefinition.getType().equals("step")) {
            policyDefinition.getLoas().forEach(loa -> loa.getCidrNotations().forEach(notation -> notation.setIpInfo(IPAddressProvider.getIpInfo((String)notation.getIpAddress(), (Integer)notation.getPrefix()))));
            policyDefinition.setActionsAllowed(false);
        }
        return policyDefinition;
    }

    private void initialPolicyValues(APIUser apiUser, PdpPolicyDefinition policyDefinition, boolean includeAuthenticatingAuthority) {
        ImpersonatedUser impersonatedUser = apiUser.getImpersonatedUser();
        if (impersonatedUser == null) {
            throw new IllegalArgumentException("ImpersonatedUser is null for apiUser: " + apiUser.getName());
        }
        if (includeAuthenticatingAuthority) {
            policyDefinition.setAuthenticatingAuthorityName(impersonatedUser.getIdpEntityId());
        }
        policyDefinition.setUserDisplayName(impersonatedUser.getUnspecifiedNameId());
    }

    private List<Map<String, Object>> attributes(Resource resource) throws IOException {
        return (List)this.objectMapper.readValue(resource.getInputStream(), this.typeReference);
    }

    private String entityID(Map<String, Object> entity) {
        return (String)((Map)entity.get("data")).get("entity");
    }

    private String name(Map<String, Object> entity) {
        return (String)((Map)((Map)entity.get("data")).get("metaDataFields")).get("name:en");
    }

    private String nameNL(Map<String, Object> entity) {
        return (String)((Map)((Map)entity.get("data")).get("metaDataFields")).get("name:nl");
    }
}

