/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class PolicyNameConstraintsHook
extends MetaDataHookAdapter {
    private final MetaDataRepository metaDataRepository;
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;

    public PolicyNameConstraintsHook(MetaDataAutoConfiguration metaDataAutoConfiguration, MetaDataRepository metaDataRepository) {
        this.metaDataRepository = metaDataRepository;
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.PDP.getType());
    }

    public MetaData prePost(MetaData metaData, AbstractUser user) {
        return this.doPre(metaData, true);
    }

    public MetaData prePut(MetaData previous, MetaData newMetaData, AbstractUser user) {
        return this.doPre(newMetaData, false);
    }

    private MetaData doPre(MetaData newMetaData, boolean isNew) {
        boolean existingError;
        String name = (String)newMetaData.getData().get("name");
        String query = "{ \"data.name\": { \"$regex\": \"^" + name + "$\", \"$options\": \"i\" } }";
        List metaDataList = this.metaDataRepository.findRaw(EntityType.PDP.getType(), query);
        boolean newError = isNew && !metaDataList.isEmpty();
        boolean bl = existingError = !isNew && metaDataList.stream().anyMatch(metaData -> !metaData.getId().equals(newMetaData.getId()) && ((String)metaData.getData().get("name")).equalsIgnoreCase(name));
        if (newError || existingError) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PDP.getType());
            throw new ValidationException(schema, "Name '" + name + "' is already taken and must be unique", "name");
        }
        return newMetaData;
    }
}

