/*
 * Decompiled with CFR 0.152.
 */
package manage.hook;

import java.util.List;
import manage.api.AbstractUser;
import manage.conf.MetaDataAutoConfiguration;
import manage.hook.MetaDataHookAdapter;
import manage.model.EntityType;
import manage.model.MetaData;
import manage.repository.MetaDataRepository;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;

public class IdentityProviderDeleteHook
extends MetaDataHookAdapter {
    private final MetaDataAutoConfiguration metaDataAutoConfiguration;
    private final MetaDataRepository metaDataRepository;

    public IdentityProviderDeleteHook(MetaDataAutoConfiguration metaDataAutoConfiguration, MetaDataRepository metaDataRepository) {
        this.metaDataAutoConfiguration = metaDataAutoConfiguration;
        this.metaDataRepository = metaDataRepository;
    }

    public boolean appliesForMetaData(MetaData metaData) {
        return metaData.getType().equals(EntityType.IDP.getType());
    }

    public MetaData preDelete(MetaData metaData, AbstractUser user) {
        String entityId = this.entityId(metaData);
        String query = String.format("{\"data.identityProviderIds.name\":\"%s\"}", entityId);
        List policies = this.metaDataRepository.findRaw(EntityType.PDP.getType(), query);
        if (!policies.isEmpty()) {
            Schema schema = this.metaDataAutoConfiguration.schema(EntityType.PDP.getType());
            List<ValidationException> exceptions = policies.stream().map(policy -> new ValidationException(schema, String.format("The policy %s uses this IdP. First remove this IdP from the policy.", policy.getData().get("name")))).toList();
            ValidationException.throwFor((Schema)schema, exceptions);
        }
        return metaData;
    }
}

