/*
 * Decompiled with CFR 0.152.
 */
package mujina.sp;

import java.security.Principal;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mujina.saml.SAMLAttribute;
import mujina.saml.SAMLBuilder;
import mujina.saml.SAMLPrincipal;
import org.opensaml.saml2.core.NameID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.SAMLCredential;
import org.springframework.security.saml.userdetails.SAMLUserDetailsService;

public class DefaultSAMLUserDetailsService
implements SAMLUserDetailsService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSAMLUserDetailsService.class);

    public Principal loadUserBySAML(SAMLCredential credential) {
        LOG.debug("loadUserBySAML {}", (Object)credential);
        List attributes = credential.getAttributes().stream().map(attribute -> new SAMLAttribute(attribute.getName(), attribute.getAttributeValues().stream().map(SAMLBuilder::getStringValueFromXMLObject).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()))).collect(Collectors.toList());
        attributes.sort(Comparator.comparing(SAMLAttribute::getName));
        NameID nameID = credential.getNameID();
        return new SAMLPrincipal(nameID.getValue(), nameID.getFormat(), attributes);
    }
}

