/*
 * Decompiled with CFR 0.152.
 */
package myconext.shibboleth.mock;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import myconext.shibboleth.mock.MockShibbolethFilter;
import org.springframework.web.filter.GenericFilterBean;

public class MockShibbolethFilter
extends GenericFilterBean {
    private final boolean serviceDeskRoleAutoProvisioning;
    private String uid = "1234567890";
    public String email = "jdoe@example.com";

    public MockShibbolethFilter(boolean serviceDeskRoleAutoProvisioning) {
        this.serviceDeskRoleAutoProvisioning = serviceDeskRoleAutoProvisioning;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        SetHeader wrapper = new SetHeader(servletRequest);
        wrapper.setHeader("schacHomeOrganization", "surfguest.nl");
        wrapper.setHeader("uid", this.uid);
        wrapper.setHeader("Shib-InetOrgPerson-mail", this.email);
        wrapper.setHeader("Shib-givenName", "John");
        wrapper.setHeader("Shib-surName", "Doe");
        if (this.serviceDeskRoleAutoProvisioning) {
            wrapper.setHeader("is-member-of", "role3");
        }
        filterChain.doFilter((ServletRequest)wrapper, response);
    }
}

