/*
 * Decompiled with CFR 0.152.
 */
package myconext.shibboleth;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import myconext.log.MDCContext;
import myconext.manage.Manage;
import myconext.model.User;
import myconext.repository.UserRepository;
import myconext.security.CookieResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    private static final Log LOG = LogFactory.getLog(ShibbolethPreAuthenticatedProcessingFilter.class);
    public static final String SHIB_GIVEN_NAME = "Shib-givenName";
    public static final String SHIB_SUR_NAME = "Shib-surName";
    public static final String SHIB_EMAIL = "Shib-InetOrgPerson-mail";
    public static final String SHIB_UID = "uid";
    public static final String SHIB_SCHAC_HOME_ORGANIZATION = "schacHomeOrganization";
    public static final String SHIB_MEMBERSHIPS = "is-member-of";
    private final UserRepository userRepository;
    private final Manage serviceProviderResolver;
    private final String mijnEduIDEntityId;
    private final List<String> serviceDeskRoles;

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager, UserRepository userRepository, Manage serviceProviderResolver, String mijnEduIDEntityId, List<String> serviceDeskRoles) {
        super.setAuthenticationManager(authenticationManager);
        this.userRepository = userRepository;
        this.serviceProviderResolver = serviceProviderResolver;
        this.mijnEduIDEntityId = mijnEduIDEntityId;
        this.serviceDeskRoles = serviceDeskRoles;
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String familyName;
        String givenName;
        String email;
        String schacHomeOrganization;
        String uid;
        boolean valid;
        Enumeration headerNames;
        if (LOG.isTraceEnabled() && (headerNames = request.getHeaderNames()) != null && !request.getRequestURI().endsWith("health") && !request.getRequestURI().endsWith("ico")) {
            Collections.list(headerNames).forEach(s -> LOG.trace((Object)String.format("Header %s, value: %s", s, request.getHeader(s))));
        }
        if (!(valid = Stream.of(uid = this.getHeader(SHIB_UID, request), schacHomeOrganization = this.getHeader(SHIB_SCHAC_HOME_ORGANIZATION, request), email = this.getHeader(SHIB_EMAIL, request), givenName = this.getHeader(SHIB_GIVEN_NAME, request), familyName = this.getHeader(SHIB_SUR_NAME, request)).allMatch(StringUtils::hasText))) {
            LOG.warn((Object)String.format("Missing required attribute(s): uid '%s', schacHomeOrganization '%s', givenName '%s', familyName '%s', email '%s'", uid, schacHomeOrganization, givenName, familyName, email));
            return null;
        }
        LOG.info((Object)String.format("Required attribute(s) present in shib headers: uid '%s', schacHomeOrganization '%s', givenName '%s', familyName '%s', email '%s'", uid, schacHomeOrganization, givenName, familyName, email));
        Optional optionalUser = this.userRepository.findUserByUid(uid);
        String preferredLanguage = CookieResolver.cookieByName((HttpServletRequest)request, (String)"lang").map(Cookie::getValue).orElse("en");
        List<String> memberships = Stream.of(this.getHeader(SHIB_MEMBERSHIPS, request).split(";")).map(String::trim).toList();
        return optionalUser.map(user -> this.syncMemberships(user, memberships)).orElseGet(() -> this.provisionUser(uid, schacHomeOrganization, givenName, familyName, email, preferredLanguage, memberships));
    }

    private User syncMemberships(User user, List<String> memberships) {
        boolean isServiceDeskMember = this.serviceDeskRoles.stream().anyMatch(memberships::contains);
        if (user.isServiceDeskMember() != isServiceDeskMember) {
            user.setServiceDeskMember(isServiceDeskMember);
            this.userRepository.save((Object)user);
        }
        return user;
    }

    private User provisionUser(String uid, String schacHomeOrganization, String givenName, String familyName, String email, String preferredLanguage, List<String> memberships) {
        User user = new User(uid, email, givenName, givenName, familyName, schacHomeOrganization, preferredLanguage, this.mijnEduIDEntityId, this.serviceProviderResolver);
        boolean isServiceDeskMember = this.serviceDeskRoles.stream().anyMatch(memberships::contains);
        user.setServiceDeskMember(isServiceDeskMember);
        user.setNewUser(false);
        user = (User)this.userRepository.save((Object)user);
        MDCContext.logWithContext((User)user, (String)"add", (String)"user", (Log)LOG, (String)String.format("Provisioned new user %s", user.getEmail()));
        return user;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        return StringUtils.hasText((String)header) ? new String(header.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8) : "";
    }
}

