/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdpScoping;
import myconext.model.ProvisionedLinkedAccount;
import myconext.model.Verification;
import myconext.model.VerifyIssuer;
import org.springframework.data.annotation.Transient;
import org.springframework.util.StringUtils;

public class ExternalLinkedAccount
implements Serializable,
ProvisionedLinkedAccount {
    private String subjectId;
    private IdpScoping idpScoping;
    private VerifyIssuer issuer;
    private Verification verification;
    private String serviceUUID;
    private String serviceID;
    private String subjectIssuer;
    private List<String> brinCodes;
    private List<String> affiliations;
    private String initials;
    private String chosenName;
    private String firstName;
    private String preferredLastName;
    private String legalLastName;
    private String partnerLastNamePrefix;
    private String legalLastNamePrefix;
    private String preferredLastNamePrefix;
    private String partnerLastName;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date dateOfBirth;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date createdAt;
    @Schema(type="integer", format="int64", example="1634813554997")
    private Date expiresAt;
    private boolean external = true;
    private boolean preferred;
    private String documentId;

    public ExternalLinkedAccount(String subjectId, IdpScoping idpScoping, boolean external) {
        this.subjectId = subjectId;
        this.idpScoping = idpScoping;
        this.external = external;
        this.expiresAt = Date.from(Instant.now().plus(1825L, ChronoUnit.DAYS));
    }

    public ExternalLinkedAccount(String subjectId, IdpScoping idpScoping, VerifyIssuer issuer, Verification verification, String serviceUUID, String serviceID, String subjectIssuer, List<String> brinCodes, String initials, String chosenName, String firstName, String preferredLastName, String legalLastName, String partnerLastNamePrefix, String legalLastNamePrefix, String preferredLastNamePrefix, String partnerLastName, Date dateOfBirth, Date createdAt, Date expiresAt, boolean external) {
        this.subjectId = subjectId;
        this.idpScoping = idpScoping;
        this.issuer = issuer;
        this.verification = verification;
        this.serviceUUID = serviceUUID;
        this.serviceID = serviceID;
        this.subjectIssuer = subjectIssuer;
        this.brinCodes = brinCodes;
        this.initials = initials;
        this.chosenName = chosenName;
        this.firstName = firstName;
        this.preferredLastName = preferredLastName;
        this.legalLastName = legalLastName;
        this.partnerLastNamePrefix = partnerLastNamePrefix;
        this.legalLastNamePrefix = legalLastNamePrefix;
        this.preferredLastNamePrefix = preferredLastNamePrefix;
        this.partnerLastName = partnerLastName;
        this.dateOfBirth = dateOfBirth;
        this.createdAt = createdAt;
        this.expiresAt = expiresAt;
        this.external = external;
        this.nameInvariant();
    }

    private void nameInvariant() {
        if (StringUtils.hasText((String)this.preferredLastName) && StringUtils.hasText((String)this.preferredLastNamePrefix)) {
            this.preferredLastName = String.format("%s %s", this.preferredLastNamePrefix, this.preferredLastName);
        }
        if (StringUtils.hasText((String)this.legalLastName) && StringUtils.hasText((String)this.legalLastNamePrefix)) {
            this.legalLastName = String.format("%s %s", this.legalLastNamePrefix, this.legalLastName);
        }
    }

    public boolean areNamesValidated() {
        return switch (1.$SwitchMap$myconext$model$IdpScoping[this.idpScoping.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                if (StringUtils.hasText((String)this.initials) && StringUtils.hasText((String)this.legalLastName)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (StringUtils.hasText((String)this.firstName) && StringUtils.hasText((String)this.preferredLastName)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (StringUtils.hasText((String)this.firstName) && StringUtils.hasText((String)this.legalLastName) && !Verification.Ongeverifieerd.equals((Object)this.verification)) {
                    yield true;
                }
                yield false;
            }
            case 4 -> StringUtils.hasText((String)this.firstName) && StringUtils.hasText((String)this.legalLastName);
        };
    }

    @JsonIgnore
    @Transient
    public ExternalLinkedAccount logoReference(List<VerifyIssuer> issuers) {
        if (this.issuer != null) {
            issuers.stream().filter(issuer -> issuer.getId().equals(this.issuer.getId())).findFirst().ifPresent(verifyIssuer -> this.issuer.setLogo(verifyIssuer.getLogo()));
        }
        return this;
    }

    public String getGivenName() {
        return IdpScoping.idin.equals((Object)this.idpScoping) ? this.initials : this.firstName;
    }

    public String getFamilyName() {
        if (StringUtils.hasText((String)this.legalLastName)) {
            return this.legalLastName;
        }
        if (StringUtils.hasText((String)this.preferredLastName)) {
            return this.preferredLastName;
        }
        return null;
    }

    @Generated
    public ExternalLinkedAccount() {
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public IdpScoping getIdpScoping() {
        return this.idpScoping;
    }

    @Generated
    public VerifyIssuer getIssuer() {
        return this.issuer;
    }

    @Generated
    public Verification getVerification() {
        return this.verification;
    }

    @Generated
    public String getServiceUUID() {
        return this.serviceUUID;
    }

    @Generated
    public String getServiceID() {
        return this.serviceID;
    }

    @Generated
    public String getSubjectIssuer() {
        return this.subjectIssuer;
    }

    @Generated
    public List<String> getBrinCodes() {
        return this.brinCodes;
    }

    @Generated
    public List<String> getAffiliations() {
        return this.affiliations;
    }

    @Generated
    public String getInitials() {
        return this.initials;
    }

    @Generated
    public String getChosenName() {
        return this.chosenName;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getPreferredLastName() {
        return this.preferredLastName;
    }

    @Generated
    public String getLegalLastName() {
        return this.legalLastName;
    }

    @Generated
    public String getPartnerLastNamePrefix() {
        return this.partnerLastNamePrefix;
    }

    @Generated
    public String getLegalLastNamePrefix() {
        return this.legalLastNamePrefix;
    }

    @Generated
    public String getPreferredLastNamePrefix() {
        return this.preferredLastNamePrefix;
    }

    @Generated
    public String getPartnerLastName() {
        return this.partnerLastName;
    }

    @Generated
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public boolean isExternal() {
        return this.external;
    }

    @Generated
    public boolean isPreferred() {
        return this.preferred;
    }

    @Generated
    public String getDocumentId() {
        return this.documentId;
    }

    @Generated
    public String toString() {
        return "ExternalLinkedAccount(subjectId=" + this.getSubjectId() + ", idpScoping=" + String.valueOf(this.getIdpScoping()) + ", issuer=" + String.valueOf(this.getIssuer()) + ", verification=" + String.valueOf(this.getVerification()) + ", serviceUUID=" + this.getServiceUUID() + ", serviceID=" + this.getServiceID() + ", subjectIssuer=" + this.getSubjectIssuer() + ", brinCodes=" + String.valueOf(this.getBrinCodes()) + ", affiliations=" + String.valueOf(this.getAffiliations()) + ", initials=" + this.getInitials() + ", chosenName=" + this.getChosenName() + ", firstName=" + this.getFirstName() + ", preferredLastName=" + this.getPreferredLastName() + ", legalLastName=" + this.getLegalLastName() + ", partnerLastNamePrefix=" + this.getPartnerLastNamePrefix() + ", legalLastNamePrefix=" + this.getLegalLastNamePrefix() + ", preferredLastNamePrefix=" + this.getPreferredLastNamePrefix() + ", partnerLastName=" + this.getPartnerLastName() + ", dateOfBirth=" + String.valueOf(this.getDateOfBirth()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", expiresAt=" + String.valueOf(this.getExpiresAt()) + ", external=" + this.isExternal() + ", preferred=" + this.isPreferred() + ", documentId=" + this.getDocumentId() + ")";
    }

    @Generated
    public void setIssuer(VerifyIssuer issuer) {
        this.issuer = issuer;
    }

    @Generated
    public void setVerification(Verification verification) {
        this.verification = verification;
    }

    @Generated
    public void setBrinCodes(List<String> brinCodes) {
        this.brinCodes = brinCodes;
    }

    @Generated
    public void setAffiliations(List<String> affiliations) {
        this.affiliations = affiliations;
    }

    @Generated
    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
    }

    @Generated
    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }
}

