/*
 * Decompiled with CFR 0.152.
 */
package myconext.api;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.stream.Stream;
import myconext.model.IdpScoping;
import myconext.repository.MetricsRepository;
import myconext.repository.UserRepository;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Hidden
public class MetricsController {
    public MetricsController(UserRepository userRepository, MetricsRepository metricsRepository, MeterRegistry meterRegistry) {
        Gauge.builder((String)"user_count", () -> userRepository.count()).description("User count").register(meterRegistry);
        Gauge.builder((String)"linked_account_count", () -> metricsRepository.countTotalLinkedAccounts()).description("Internal linked account count").register(meterRegistry);
        Gauge.builder((String)"registered_apps_count", () -> metricsRepository.countTotalRegisteredApps()).description("Registered apps count").register(meterRegistry);
        Stream.of(IdpScoping.values()).forEach(idpScoping -> Gauge.builder((String)("external_linked_account_" + idpScoping.name()), () -> metricsRepository.countTotalExternalLinkedAccountsByType(idpScoping)).description("External account " + idpScoping.name() + " count ").register(meterRegistry));
    }
}

