/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.SequencedCollection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import myconext.mail.MailBox;
import myconext.model.User;
import myconext.model.UserInactivity;
import myconext.repository.UserRepository;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InactivityMail {
    public static final long ONE_DAY_IN_MILLIS = 86400000L;
    private static final Log LOG = LogFactory.getLog(InactivityMail.class);
    private final MailBox mailBox;
    private final UserRepository userRepository;
    private final boolean mailInactivityMails;
    private final boolean cronJobResponsible;
    private final DateFormat dateFormatUS;
    private final DateFormat dateFormatNL;
    private final boolean dryRunEmail;

    @Autowired
    public InactivityMail(MailBox mailBox, UserRepository userRepository, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible, @Value(value="${feature.mail_inactivity_mails}") boolean mailInactivityMails, @Value(value="${cron.dry-run-email}") boolean dryRunEmail) {
        this.mailBox = mailBox;
        this.userRepository = userRepository;
        this.cronJobResponsible = cronJobResponsible;
        this.mailInactivityMails = mailInactivityMails;
        this.dryRunEmail = dryRunEmail;
        this.dateFormatUS = DateFormat.getDateInstance(1, Locale.of("us"));
        this.dateFormatNL = DateFormat.getDateInstance(1, Locale.of("nl"));
    }

    @Scheduled(cron="${cron.inactivity-users-expression}")
    public void mailInactiveUsers() {
        if (!this.mailInactivityMails || !this.cronJobResponsible) {
            return;
        }
        try {
            SequencedCollection userInactivities = Stream.of(UserInactivity.values()).toList().reversed();
            userInactivities.forEach(arg_0 -> this.doMailInactiveUsers(arg_0));
            this.doDeleteInactiveUsers();
        }
        catch (Exception e) {
            LOG.error((Object)"Error in mailInactiveUsers", (Throwable)e);
        }
    }

    private void doMailInactiveUsers(UserInactivity userInactivity) {
        LOG.info((Object)"Starting InactivityMail job");
        long nowInMillis = System.currentTimeMillis();
        long fiveYearsInMillis = 157680000000L;
        long lastLoginBefore = nowInMillis - 86400000L * userInactivity.getInactivityDays();
        List users = this.userRepository.findByLastLoginBeforeAndUserInactivityIn(lastLoginBefore, this.userInactivitiesWithNullElement(userInactivity.getPreviousUserInactivity()));
        HashMap<String, String> localeVariables = new HashMap<String, String>();
        Date date = new Date(nowInMillis + (fiveYearsInMillis - 86400000L * userInactivity.getInactivityDays()));
        localeVariables.put("inactivity_period_en", userInactivity.getInactivityPeriodEn());
        localeVariables.put("inactivity_period_nl", userInactivity.getInactivityPeriodNl());
        localeVariables.put("deletion_period_en", userInactivity.getDeletionPeriodEn());
        localeVariables.put("deletion_period_nl", userInactivity.getDeletionPeriodNl());
        localeVariables.put("account_delete_date_en", this.dateFormatUS.format(date));
        localeVariables.put("account_delete_date_nl", this.dateFormatNL.format(date));
        if (!this.dryRunEmail) {
            users.forEach(user -> {
                this.mailBox.sendUserInactivityMail(user, localeVariables, userInactivity.equals((Object)UserInactivity.YEAR_1_INTERVAL) || userInactivity.equals((Object)UserInactivity.YEAR_3_INTERVAL));
                user.setUserInactivity(userInactivity);
                if (userInactivity.equals((Object)UserInactivity.WEEK_1_BEFORE_5_YEARS)) {
                    user.setLastLogin(nowInMillis - UserInactivity.WEEK_1_BEFORE_5_YEARS.getInactivityDays() * 86400000L);
                }
                this.userRepository.save(user);
            });
        }
        LOG.info((Object)String.format("%s %s users who has been inactive for %s period in for %s ms, dry run: %s", this.dryRunEmail ? "Would have mailed" : "Mailed", users.size(), userInactivity, System.currentTimeMillis() - nowInMillis, this.dryRunEmail));
    }

    private void doDeleteInactiveUsers() {
        long nowInMillis = System.currentTimeMillis();
        long lastLoginBefore = nowInMillis - 157680000000L;
        List users = this.userRepository.findByLastLoginBeforeAndUserInactivityIn(lastLoginBefore, List.of(UserInactivity.WEEK_1_BEFORE_5_YEARS));
        if (!this.dryRunEmail) {
            this.userRepository.deleteAll((Iterable)users);
        }
        LOG.info((Object)String.format("%s %s users (%s) who has been inactive for 5 years in for %s ms, dry-run: %s", this.dryRunEmail ? "Would have deleted" : "Deleted", users.size(), users.stream().map(User::getEmail).collect(Collectors.joining(", ")), System.currentTimeMillis() - nowInMillis, this.dryRunEmail));
    }

    private List<UserInactivity> userInactivitiesWithNullElement(UserInactivity userInactivity) {
        ArrayList<UserInactivity> userInactivities = new ArrayList<UserInactivity>();
        userInactivities.add(userInactivity);
        userInactivities.add(null);
        return userInactivities;
    }
}

