/*
 * Decompiled with CFR 0.152.
 */
package myconext.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Document(collection="external_users")
public class ExternalUser
implements Serializable,
UserDetails {
    private static final List<SimpleGrantedAuthority> GUEST_AUTHORITIES = List.of(new SimpleGrantedAuthority("ROLE_GUEST"));
    private static final List<SimpleGrantedAuthority> SERVICE_DESK_AUTHORIES = Stream.of("ROLE_GUEST", "SERVICE_DESK").map(SimpleGrantedAuthority::new).toList();
    @Id
    private String id;
    private String email;
    private String givenName;
    private String familyName;
    @Indexed
    private String uid;
    private String schacHomeOrganization;
    private boolean newUser;
    private long created;
    private long lastLogin;
    private boolean serviceDeskMember;

    public ExternalUser(String uid, String email, String givenName, String familyName, String schacHomeOrganization) {
        this.uid = uid;
        this.email = email;
        this.givenName = givenName;
        this.familyName = familyName;
        this.schacHomeOrganization = StringUtils.hasText((String)schacHomeOrganization) ? schacHomeOrganization.toLowerCase() : schacHomeOrganization;
        this.created = System.currentTimeMillis() / 1000L;
    }

    public void validate() {
        Assert.notNull((Object)this.email, (String)"Email is required");
        Assert.notNull((Object)this.givenName, (String)"GivenName is required");
        Assert.notNull((Object)this.familyName, (String)"FamilyName is required");
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        if (this.serviceDeskMember) {
            return SERVICE_DESK_AUTHORIES;
        }
        return GUEST_AUTHORITIES;
    }

    public String getPassword() {
        return "";
    }

    @JsonIgnore
    public String getUsername() {
        return this.email;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @Transient
    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    public String getEduPersonPrincipalName() {
        return this.uid + "@" + this.schacHomeOrganization;
    }

    public Map<String, Object> serviceDeskSummary() {
        return Map.of("name", String.format("%s %s", this.getGivenName(), this.getFamilyName()), "email", this.email, "serviceDeskMember", this.serviceDeskMember);
    }

    public String getName() {
        return String.format("%s %s", this.givenName, this.familyName);
    }

    @Generated
    public ExternalUser() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getFamilyName() {
        return this.familyName;
    }

    @Generated
    public String getUid() {
        return this.uid;
    }

    @Generated
    public String getSchacHomeOrganization() {
        return this.schacHomeOrganization;
    }

    @Generated
    public boolean isNewUser() {
        return this.newUser;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public long getLastLogin() {
        return this.lastLogin;
    }

    @Generated
    public boolean isServiceDeskMember() {
        return this.serviceDeskMember;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    @Generated
    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    @Generated
    public void setNewUser(boolean newUser) {
        this.newUser = newUser;
    }

    @Generated
    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    @Generated
    public void setServiceDeskMember(boolean serviceDeskMember) {
        this.serviceDeskMember = serviceDeskMember;
    }
}

