/*
 * Decompiled with CFR 0.152.
 */
package myconext.mongo;

import com.mongodb.client.MongoClient;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

@Component
public class ExtendedMongoHealthIndicator
implements HealthIndicator {
    private final MongoClient mongoClient;

    public ExtendedMongoHealthIndicator(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public Health health() {
        try {
            this.mongoClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
            Document serverStatus = this.mongoClient.getDatabase("admin").runCommand((Bson)new Document("serverStatus", (Object)1));
            String host = serverStatus.getString((Object)"host");
            String version = serverStatus.getString((Object)"version");
            Double uptime = serverStatus.getDouble((Object)"uptime");
            Document connections = (Document)serverStatus.get((Object)"connections");
            String databaseName = (String)this.mongoClient.listDatabaseNames().first();
            return Health.up().withDetail("host", (Object)host).withDetail("version", (Object)version).withDetail("uptimeSeconds", (Object)uptime).withDetail("connections", (Object)connections).withDetail("defaultDatabase", (Object)databaseName).withDetail("maxWireVersion", (Object)this.getMaxWireVersion()).build();
        }
        catch (Exception e) {
            return Health.down((Throwable)e).build();
        }
    }

    private int getMaxWireVersion() {
        try {
            Document buildInfo = this.mongoClient.getDatabase("admin").runCommand((Bson)new Document("buildInfo", (Object)1));
            return buildInfo.getInteger((Object)"maxWireVersion", -1);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

