/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CookieValueEncoder {
    private final String salt;

    public CookieValueEncoder(@Value(value="${tiqr_hash_secret}") String salt) {
        this.salt = salt;
    }

    public String encode(String value) {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        messageDigest.update(this.salt.getBytes(StandardCharsets.UTF_8));
        byte[] bytes = messageDigest.digest(value.getBytes(StandardCharsets.UTF_8));
        byte[] encoded = Base64.encodeBase64((byte[])bytes);
        return new String(encoded);
    }

    public boolean matches(String rawValue, String encoded) {
        return this.encode(rawValue).equals(encoded);
    }
}

