/*
 * Decompiled with CFR 0.152.
 */
package myconext.sms;

import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import myconext.sms.SMSService;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SMSServiceImpl
implements SMSService {
    private static final Log LOG = LogFactory.getLog(SMSServiceImpl.class);
    private final String url;
    public final String route;
    private final String templateNl;
    private final String templateEn;
    private final RestTemplate restTemplate = new RestTemplate();
    private final String bearer;

    public SMSServiceImpl(String url, String bearer, String route) {
        this.url = url;
        this.templateNl = IOUtils.toString((InputStream)new ClassPathResource("sms/template_nl.txt").getInputStream(), (Charset)Charset.defaultCharset());
        this.templateEn = IOUtils.toString((InputStream)new ClassPathResource("sms/template_en.txt").getInputStream(), (Charset)Charset.defaultCharset());
        this.route = route;
        this.bearer = bearer;
        LOG.info((Object)("Converters: " + String.valueOf(this.restTemplate.getMessageConverters())));
        this.restTemplate.getInterceptors().add((request, body, execution) -> {
            LOG.info((Object)String.format("Sending SMS request to %s with headers %s and body:\n%s", request.getURI(), request.getHeaders(), new String(body, StandardCharsets.UTF_8)));
            return execution.execute(request, body);
        });
    }

    protected String formatMessage(String code, Locale locale) {
        String template = locale != null && "nl".equalsIgnoreCase(locale.getLanguage()) ? this.templateNl : this.templateEn;
        return String.format(template, code);
    }

    public String send(String mobile, String code, Locale locale) {
        String format = this.formatMessage(code, locale);
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("encoding", "auto");
        body.put("body", format);
        body.put("route", this.route);
        body.put("originator", "eduID");
        body.put("recipients", Collections.singletonList(mobile));
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.setBearerAuth(this.bearer);
        RequestEntity requestEntity = new RequestEntity(body, (MultiValueMap)headers, HttpMethod.POST, URI.create(this.url));
        this.restTemplate.exchange(requestEntity, Void.class);
        return format;
    }
}

