/*
 * Decompiled with CFR 0.152.
 */
package myconext.cron;

import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.Updates;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import myconext.cron.Executable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class AbstractNodeLeader {
    private static final Log LOG = LogFactory.getLog(AbstractNodeLeader.class);
    private static final String LOCK_COLLECTION = "distributed_locks";
    private static final int LOCK_TIMEOUT_SECONDS = 300;
    private final String lockName;
    private final MongoClient mongoClient;
    private final String databaseName;

    protected AbstractNodeLeader(String lockName, MongoClient mongoClient, String databaseName) {
        this.lockName = lockName;
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.ensureIndexes();
    }

    private void ensureIndexes() {
        try {
            MongoDatabase database = this.mongoClient.getDatabase(this.databaseName);
            MongoCollection collection = database.getCollection(LOCK_COLLECTION);
            IndexOptions indexOptions = new IndexOptions();
            Document indexDocument = new Document("expiresAt", (Object)1);
            collection.createIndex((Bson)indexDocument, indexOptions.expireAfter(Long.valueOf(0L), TimeUnit.SECONDS));
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to create indexes for distributed locks", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void perform(String name, Executable executable) {
        boolean lockAcquired;
        String nodeId;
        block13: {
            nodeId = null;
            lockAcquired = false;
            nodeId = this.generateNodeId();
            lockAcquired = this.tryGetLock(this.lockName, nodeId);
            if (lockAcquired) break block13;
            LOG.info((Object)String.format("Another node is running %s, skipping this one", name));
            if (!lockAcquired || nodeId == null) return;
            try {
                this.releaseLock(this.lockName, nodeId);
                LOG.info((Object)String.format("Lock released for %s", name));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
            }
            return;
        }
        LOG.info((Object)String.format("Lock acquired for %s", name));
        executable.execute();
        LOG.info((Object)String.format("Executable %s completed successfully", name));
        if (!lockAcquired || nodeId == null) return;
        try {
            this.releaseLock(this.lockName, nodeId);
            LOG.info((Object)String.format("Lock released for %s", name));
            return;
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
        }
        return;
        catch (Throwable e) {
            try {
                LOG.error((Object)String.format("Error occurred in %s", name), e);
                if (!lockAcquired || nodeId == null) return;
            }
            catch (Throwable throwable) {
                if (!lockAcquired || nodeId == null) throw throwable;
                try {
                    this.releaseLock(this.lockName, nodeId);
                    LOG.info((Object)String.format("Lock released for %s", name));
                    throw throwable;
                }
                catch (Exception e2) {
                    LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e2);
                }
                throw throwable;
            }
            try {
                this.releaseLock(this.lockName, nodeId);
                LOG.info((Object)String.format("Lock released for %s", name));
                return;
            }
            catch (Exception e3) {
                LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e3);
            }
            return;
        }
    }

    protected boolean tryGetLock(String name, String nodeId) {
        try {
            MongoDatabase database = this.mongoClient.getDatabase(this.databaseName);
            MongoCollection collection = database.getCollection(LOCK_COLLECTION);
            Instant now = Instant.now();
            Instant expiresAt = now.plusSeconds(300L);
            try {
                Document lockDoc = new Document().append("_id", (Object)name).append("nodeId", (Object)nodeId).append("acquiredAt", (Object)Date.from(now)).append("expiresAt", (Object)Date.from(expiresAt));
                collection.insertOne((Object)lockDoc);
                return true;
            }
            catch (MongoWriteException e) {
                if (e.getCode() == 11000) {
                    Document result = (Document)collection.findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)name), Filters.lt((String)"expiresAt", (Object)Date.from(now))}), Updates.combine((Bson[])new Bson[]{Updates.set((String)"nodeId", (Object)nodeId), Updates.set((String)"acquiredAt", (Object)Date.from(now)), Updates.set((String)"expiresAt", (Object)Date.from(expiresAt))}), new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER));
                    return result != null && nodeId.equals(result.getString((Object)"nodeId"));
                }
                throw e;
            }
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to acquire lock %s", name), (Throwable)e);
            return false;
        }
    }

    protected void releaseLock(String name, String nodeId) {
        try {
            MongoDatabase database = this.mongoClient.getDatabase(this.databaseName);
            MongoCollection collection = database.getCollection(LOCK_COLLECTION);
            collection.deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)name), Filters.eq((String)"nodeId", (Object)nodeId)}));
        }
        catch (Exception e) {
            LOG.error((Object)String.format("Failed to release lock %s", name), (Throwable)e);
        }
    }

    protected String generateNodeId() {
        return String.format("%s-%s-%d", this.getHostName(), Thread.currentThread().getName(), System.currentTimeMillis());
    }

    private String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "unknown-host";
        }
    }
}

