/*
 * Decompiled with CFR 0.152.
 */
package myconext.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import myconext.crypto.HashGenerator;
import myconext.exceptions.UserNotFoundException;
import myconext.geo.GeoLocation;
import myconext.log.MDCContext;
import myconext.mail.MailBox;
import myconext.manage.Manage;
import myconext.model.ExternalLinkedAccount;
import myconext.model.IdpScoping;
import myconext.model.LinkedAccount;
import myconext.model.LoginOptions;
import myconext.model.LoginStatus;
import myconext.model.SamlAuthenticationRequest;
import myconext.model.StepUpStatus;
import myconext.model.User;
import myconext.model.UserLogin;
import myconext.model.Verification;
import myconext.repository.AuthenticationRequestRepository;
import myconext.repository.UserLoginRepository;
import myconext.repository.UserRepository;
import myconext.security.ACR;
import myconext.security.CookieResolver;
import myconext.security.CookieValueEncoder;
import myconext.security.IdentityProviderMetaData;
import myconext.security.UserAuthenticationToken;
import myconext.security.VerificationCodeGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.RequesterID;
import org.opensaml.saml.saml2.core.Scoping;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import saml.DefaultSAMLService;
import saml.model.SAMLAttribute;
import saml.model.SAMLConfiguration;
import saml.model.SAMLStatus;

/*
 * Exception performing whole class analysis ignored.
 */
public class GuestIdpAuthenticationRequestFilter
extends OncePerRequestFilter {
    public static final String GUEST_IDP_REMEMBER_ME_COOKIE_NAME = "guest-idp-remember-me";
    public static final String TRACKING_DEVICE_COOKIE_NAME = "TRACKING_DEVICE";
    public static final String BROWSER_SESSION_COOKIE_NAME = "BROWSER_SESSION";
    public static final String REGISTER_MODUS_COOKIE_NAME = "REGISTER_MODUS";
    public static final String TIQR_COOKIE_NAME = "TIQR_COOKIE";
    public static final String REMEMBER_ME_QUESTION_ASKED_COOKIE_NAME = "REMEMBER_ME_QUESTION_ASKED_COOKIE";
    private static final Log LOG = LogFactory.getLog(GuestIdpAuthenticationRequestFilter.class);
    public static final String ROLE_MFA = "ROLE_MFA";
    private final PathPatternRequestMatcher ssoSamlRequestMatcher;
    private final PathPatternRequestMatcher magicSamlRequestMatcher;
    private final PathPatternRequestMatcher continueAfterLoginSamlRequestMatcher;
    private final PathPatternRequestMatcher metaDataSamlRequestMatcher;
    private final String redirectUrl;
    private final AuthenticationRequestRepository authenticationRequestRepository;
    private final IdentityProviderMetaData identityProviderMetaData;
    private final SecurityContextRepository securityContextRepository;
    private UserRepository userRepository;
    private final UserLoginRepository userLoginRepository;
    private final List<String> accountLinkingContextClassReferences;
    private final GeoLocation geoLocation;
    private final int rememberMeMaxAge;
    private final int tiqrCookieMaxAge;
    private final boolean secureCookie;
    private final String magicLinkUrl;
    private final MailBox mailBox;
    private Manage manage;
    private final ExecutorService executor;
    private final int nudgeAppDays;
    private final int nudgeAppDelayDays;
    private final int rememberMeQuestionAskedDays;
    private final long expiryNonValidatedDurationDays;
    private final long ssoMFADurationSeconds;
    private final String mobileAppROEntityId;
    private final boolean featureDefaultRememberMe;
    private final boolean featureDefaultAffiliateEmail;
    private final boolean featureUseApp;
    private final String defaultAffiliateEmailDomain;
    private final DefaultSAMLService samlService;
    private final CookieValueEncoder cookieValueEncoder;

    public GuestIdpAuthenticationRequestFilter(String redirectUrl, Manage manage, AuthenticationRequestRepository authenticationRequestRepository, UserRepository userRepository, UserLoginRepository userLoginRepository, GeoLocation geoLocation, int rememberMeMaxAge, int tiqrCookieMaxAge, int nudgeAppDays, int nudgeAppDelayDays, int rememberMeQuestionAskedDays, boolean secureCookie, String magicLinkUrl, MailBox mailBox, long expiryNonValidatedDurationDays, long ssoMFADurationSeconds, String mobileAppROEntityId, boolean featureDefaultRememberMe, boolean featureDefaultAffiliateEmail, boolean featureUseApp, String defaultAffiliateEmailDomain, SAMLConfiguration configuration, IdentityProviderMetaData identityProviderMetaData, CookieValueEncoder cookieValueEncoder, SecurityContextRepository securityContextRepository) {
        this.cookieValueEncoder = cookieValueEncoder;
        this.ssoSamlRequestMatcher = PathPatternRequestMatcher.withDefaults().matcher("/saml/guest-idp/SSO/**");
        this.magicSamlRequestMatcher = PathPatternRequestMatcher.withDefaults().matcher("/saml/guest-idp/magic/**");
        this.continueAfterLoginSamlRequestMatcher = PathPatternRequestMatcher.withDefaults().matcher("/saml/guest-idp/continue/**");
        this.metaDataSamlRequestMatcher = PathPatternRequestMatcher.withDefaults().matcher("/saml/guest-idp/metadata/**");
        this.redirectUrl = redirectUrl;
        this.manage = manage;
        this.authenticationRequestRepository = authenticationRequestRepository;
        this.userRepository = userRepository;
        this.userLoginRepository = userLoginRepository;
        this.geoLocation = geoLocation;
        this.accountLinkingContextClassReferences = ACR.allAccountLinkingContextClassReferences();
        this.rememberMeMaxAge = rememberMeMaxAge;
        this.tiqrCookieMaxAge = tiqrCookieMaxAge;
        this.nudgeAppDays = nudgeAppDays;
        this.nudgeAppDelayDays = nudgeAppDelayDays;
        this.rememberMeQuestionAskedDays = rememberMeQuestionAskedDays;
        this.secureCookie = secureCookie;
        this.magicLinkUrl = magicLinkUrl;
        this.mailBox = mailBox;
        this.expiryNonValidatedDurationDays = expiryNonValidatedDurationDays;
        this.ssoMFADurationSeconds = ssoMFADurationSeconds;
        this.mobileAppROEntityId = mobileAppROEntityId;
        this.featureDefaultRememberMe = featureDefaultRememberMe;
        this.featureDefaultAffiliateEmail = featureDefaultAffiliateEmail;
        this.featureUseApp = featureUseApp;
        this.defaultAffiliateEmailDomain = defaultAffiliateEmailDomain;
        this.samlService = new DefaultSAMLService(configuration);
        this.executor = Executors.newSingleThreadExecutor();
        this.identityProviderMetaData = identityProviderMetaData;
        this.securityContextRepository = securityContextRepository;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.ssoSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting SSO filter");
            this.sso(request, response);
            return;
        }
        if (this.magicSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting magic filter");
            this.magic(request, response);
            return;
        }
        if (this.continueAfterLoginSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting continue after login filter");
            this.continueAfterLogin(request, response);
            return;
        }
        if (this.metaDataSamlRequestMatcher.matches(request)) {
            LOG.debug((Object)"Starting metadata filter");
            this.metaData(response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void sso(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String samlRequest = request.getParameter("SAMLRequest");
        String relayState = request.getParameter("RelayState");
        if (!StringUtils.hasText((String)samlRequest)) {
            return;
        }
        if (!HttpMethod.GET.name().equalsIgnoreCase(request.getMethod())) {
            throw new IllegalArgumentException("Only GET redirect are support. Not: " + request.getMethod());
        }
        AuthnRequest authnRequest = this.samlService.parseAuthnRequest(samlRequest, true, true);
        String requesterEntityId = this.requesterId(authnRequest);
        String issuer = authnRequest.getIssuer().getValue();
        List authenticationContextClassReferenceValues = this.getAuthenticationContextClassReferenceValues(authnRequest);
        boolean accountLinkingRequired = ACR.containsAnyAcr((List)authenticationContextClassReferenceValues, (List)this.accountLinkingContextClassReferences);
        boolean mfaProfileRequired = ACR.containsMfaAcr((List)authenticationContextClassReferenceValues);
        SamlAuthenticationRequest samlAuthenticationRequest = new SamlAuthenticationRequest(authnRequest.getID(), issuer, authnRequest.getAssertionConsumerServiceURL(), relayState, StringUtils.hasText((String)requesterEntityId) ? requesterEntityId : "", accountLinkingRequired, mfaProfileRequired, authenticationContextClassReferenceValues);
        Optional rememberMeCookieOptional = CookieResolver.cookieByName((HttpServletRequest)request, (String)"guest-idp-remember-me");
        Optional userRememberedOptional = rememberMeCookieOptional.map(arg_0 -> this.userFromCookie(arg_0)).flatMap(Function.identity());
        Optional userFromAuthentication = this.userFromAuthentication();
        User previousAuthenticatedUser = userRememberedOptional.orElse(userFromAuthentication.orElse(null));
        String serviceName = this.manage.getServiceName(request, samlAuthenticationRequest);
        samlAuthenticationRequest.setServiceName(serviceName);
        samlAuthenticationRequest = (SamlAuthenticationRequest)this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        if (previousAuthenticatedUser != null && !authnRequest.isForceAuthn().booleanValue()) {
            boolean applySsoMfa = this.isApplySsoMfa();
            if (!applySsoMfa && mfaProfileRequired || accountLinkingRequired && !this.isUserVerifiedByInstitution(previousAuthenticatedUser, authenticationContextClassReferenceValues)) {
                boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)previousAuthenticatedUser.allEduPersonAffiliations());
                String explanation = ACR.explanationKeyWord((List)authenticationContextClassReferenceValues, (boolean)hasStudentAffiliation);
                samlAuthenticationRequest.setUserId(previousAuthenticatedUser.getId());
                samlAuthenticationRequest.setHash(HashGenerator.hash());
                this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
                this.addBrowserIdentificationCookie(response);
                Object redirect = "/stepup/";
                String mfa = "";
                if (mfaProfileRequired) {
                    List loginOptions = previousAuthenticatedUser.loginOptions();
                    if (loginOptions.contains(LoginOptions.APP.getValue())) {
                        redirect = "/" + LoginOptions.APP.getValue().toLowerCase() + "/";
                        mfa = "&mfa=true";
                    } else {
                        redirect = "/" + ((String)loginOptions.get(0)).toLowerCase() + "/";
                    }
                }
                String location = this.redirectUrl + (String)redirect + samlAuthenticationRequest.getId() + "?explanation=" + explanation + mfa;
                response.sendRedirect(location);
            } else {
                this.sendAssertion(request, response, samlAuthenticationRequest, previousAuthenticatedUser);
            }
        } else {
            this.addBrowserIdentificationCookie(response);
            Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"REGISTER_MODUS");
            LOG.debug((Object)("Cookie REGISTER_MODUS_COOKIE_NAME is: " + optionalCookie.map(Cookie::getValue).orElse("Null")));
            String stepUp = accountLinkingRequired ? "&stepup=true" : "";
            String mfa = mfaProfileRequired ? "&mfa=true" : "";
            String preferMagicLink = this.nudgeMagicLink(authnRequest) ? "&magicLink=true" : "";
            String separator = accountLinkingRequired || mfaProfileRequired || StringUtils.hasText((String)preferMagicLink) ? "?n=1" : "";
            String path = optionalCookie.map(c -> "/request/").orElse("/login/");
            String location = this.redirectUrl + path + samlAuthenticationRequest.getId() + separator + stepUp + mfa + preferMagicLink;
            Cookie registerCookie = new Cookie("REGISTER_MODUS", "");
            registerCookie.setMaxAge(0);
            response.addCookie(registerCookie);
            response.sendRedirect(location);
        }
    }

    private boolean isApplySsoMfa() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof UserAuthenticationToken) {
            UserAuthenticationToken userAuthenticationToken = (UserAuthenticationToken)authentication;
            long createdAt = userAuthenticationToken.getCreatedAt();
            boolean mfaRole = userAuthenticationToken.getAuthorities().stream().anyMatch(auth -> auth.getAuthority().equals("ROLE_MFA"));
            return mfaRole && System.currentTimeMillis() - createdAt < this.ssoMFADurationSeconds * 1000L;
        }
        return false;
    }

    public boolean isUserVerifiedByInstitution(User user, List<String> authenticationContextClassReferenceValues) {
        authenticationContextClassReferenceValues = authenticationContextClassReferenceValues == null ? Collections.emptyList() : authenticationContextClassReferenceValues;
        List linkedAccounts = user.getLinkedAccounts();
        List externalLinkedAccounts = user.getExternalLinkedAccounts();
        if (CollectionUtils.isEmpty((Collection)linkedAccounts) && CollectionUtils.isEmpty((Collection)externalLinkedAccounts)) {
            return false;
        }
        Instant now = new Date().toInstant();
        boolean validateNamesExternalAcr = ACR.containsAcr(authenticationContextClassReferenceValues, (String)ACR.VALIDATE_NAMES_EXTERNAL);
        if (validateNamesExternalAcr) {
            return externalLinkedAccounts.stream().anyMatch(externalLinkedAccount -> externalLinkedAccount.getExpiresAt().toInstant().isAfter(now) && !Verification.Ongeverifieerd.equals((Object)externalLinkedAccount.getVerification()));
        }
        boolean validatedName = GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        boolean validatedNameACR = ACR.containsAcr(authenticationContextClassReferenceValues, (String)ACR.VALIDATE_NAMES);
        List nonExpiredLinkedAccounts = linkedAccounts.stream().filter(linkedAccount -> {
            Instant expiresAt = linkedAccount.getExpiresAt().toInstant();
            if (!validatedNameACR) {
                expiresAt = linkedAccount.getCreatedAt().toInstant().plus(this.expiryNonValidatedDurationDays, ChronoUnit.DAYS);
            }
            return now.isBefore(expiresAt);
        }).collect(Collectors.toList());
        List nonExpiredExternalLinkedAccounts = externalLinkedAccounts.stream().filter(externalLinkedAccount -> {
            Instant expiresAt = externalLinkedAccount.getExpiresAt().toInstant();
            return now.isBefore(expiresAt);
        }).collect(Collectors.toList());
        boolean atLeastOneNotExpired = !CollectionUtils.isEmpty(nonExpiredLinkedAccounts) || !CollectionUtils.isEmpty(nonExpiredExternalLinkedAccounts);
        boolean hasRequiredStudentAffiliation = !ACR.containsAcr(authenticationContextClassReferenceValues, (String)ACR.AFFILIATION_STUDENT) || nonExpiredLinkedAccounts.stream().anyMatch(linkedAccount -> GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)linkedAccount.getEduPersonAffiliations()));
        boolean hasValidatedNames = !ACR.containsAcr(authenticationContextClassReferenceValues, (String)ACR.VALIDATE_NAMES) || validatedName;
        boolean linkedInstitutionMissing = ACR.containsAcr(authenticationContextClassReferenceValues, (String)ACR.LINKED_INSTITUTION) && nonExpiredLinkedAccounts.isEmpty();
        return atLeastOneNotExpired && hasRequiredStudentAffiliation && hasValidatedNames && !linkedInstitutionMissing;
    }

    public static boolean hasValidatedName(User user) {
        return user.getLinkedAccounts().stream().anyMatch(LinkedAccount::areNamesValidated) || user.getExternalLinkedAccounts().stream().anyMatch(ExternalLinkedAccount::areNamesValidated);
    }

    public static boolean hasValidatedExternalName(User user) {
        return user.getExternalLinkedAccounts().stream().anyMatch(ExternalLinkedAccount::areNamesValidated);
    }

    public static boolean hasRequiredStudentAffiliation(List<String> affiliations) {
        return !CollectionUtils.isEmpty(affiliations) && affiliations.stream().anyMatch(affiliation -> affiliation.toLowerCase().contains("student"));
    }

    private List<String> getAuthenticationContextClassReferenceValues(AuthnRequest authenticationRequest) {
        RequestedAuthnContext requestedAuthnContext = authenticationRequest.getRequestedAuthnContext();
        if (requestedAuthnContext == null) {
            return Collections.emptyList();
        }
        List authnContextClassRefs = requestedAuthnContext.getAuthnContextClassRefs();
        if (authnContextClassRefs == null) {
            return Collections.emptyList();
        }
        return authnContextClassRefs.stream().map(XSURI::getURI).collect(Collectors.toList());
    }

    private Optional<User> userFromCookie(Cookie remembered) {
        LOG.debug((Object)"Returning user from rememberMe cookie");
        return this.authenticationRequestRepository.findByRememberMeValue(remembered.getValue()).map(req -> this.userRepository.findById((Object)req.getUserId())).flatMap(Function.identity());
    }

    private Optional<User> userFromAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        LOG.debug((Object)("Attempting user authentication from security context: " + String.valueOf(authentication)));
        if (authentication != null && authentication.isAuthenticated() && authentication instanceof UsernamePasswordAuthenticationToken) {
            User user = (User)authentication.getPrincipal();
            return this.userRepository.findById((Object)user.getId());
        }
        return Optional.empty();
    }

    private void addBrowserIdentificationCookie(HttpServletResponse response) {
        response.setHeader("Set-Cookie", "BROWSER_SESSION=true; SameSite=Lax" + (this.secureCookie ? "; Secure" : ""));
    }

    private String requesterId(AuthnRequest authenticationRequest) {
        Issuer issuer = authenticationRequest.getIssuer();
        String issuerValue = issuer != null ? issuer.getValue() : "";
        Scoping scoping = authenticationRequest.getScoping();
        List requesterIDS = scoping != null ? scoping.getRequesterIDs() : null;
        return CollectionUtils.isEmpty((Collection)requesterIDS) ? issuerValue : ((RequesterID)requesterIDS.get(0)).getURI();
    }

    private boolean nudgeMagicLink(AuthnRequest authenticationRequest) {
        Scoping scoping = authenticationRequest.getScoping();
        List requesterIDS = scoping != null ? scoping.getRequesterIDs() : null;
        return !CollectionUtils.isEmpty((Collection)requesterIDS) && requesterIDS.stream().anyMatch(requesterID -> this.mobileAppROEntityId.equalsIgnoreCase(requesterID.getURI()));
    }

    private void magic(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String hash = request.getParameter("h");
        if (!StringUtils.hasText((String)hash)) {
            Map<String, String> headerMap = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(headerName -> headerName, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            LOG.warn((Object)("Magic endpoint without 'h' parameter. Headers: " + String.valueOf(headerMap)));
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findByHash(hash);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        boolean accountLinkingRequired = samlAuthenticationRequest.isAccountLinkingRequired() && !this.isUserVerifiedByInstitution(user, authenticationContextClassReferences);
        String charSet = Charset.defaultCharset().name();
        boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
        String explanation = ACR.explanationKeyWord((List)authenticationContextClassReferences, (boolean)hasStudentAffiliation);
        String force = request.getParameter("force");
        if (accountLinkingRequired && StepUpStatus.NONE.equals((Object)samlAuthenticationRequest.getSteppedUp()) && !StringUtils.hasText((String)force)) {
            response.sendRedirect(this.redirectUrl + "/stepup/" + samlAuthenticationRequest.getId() + "?explanation=" + explanation);
            return;
        }
        if (samlAuthenticationRequest.isMfaProfileRequired() && !samlAuthenticationRequest.isTiqrFlow() && !StringUtils.hasText((String)force)) {
            response.sendRedirect(this.redirectUrl + "/app-required?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet));
            return;
        }
        Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"BROWSER_SESSION");
        if (!optionalCookie.isPresent() && !samlAuthenticationRequest.isOneTimeLoginCodeFlow()) {
            samlAuthenticationRequest.setLoginStatus(LoginStatus.LOGGED_IN_DIFFERENT_DEVICE);
            samlAuthenticationRequest.setVerificationCode(VerificationCodeGenerator.generate());
            if (this.incrementVerificationCodeRetry(samlAuthenticationRequest)) {
                response.sendRedirect(this.redirectUrl + "/max-attempts");
                return;
            }
            this.mailBox.sendVerificationCode(user, samlAuthenticationRequest.getVerificationCode());
            response.sendRedirect(this.redirectUrl + "/success");
            return;
        }
        boolean proceed = this.checkStepUp(response, request, hash, samlAuthenticationRequest, user, charSet, explanation);
        if (!proceed) {
            return;
        }
        samlAuthenticationRequest.setLoginStatus(LoginStatus.LOGGED_IN_SAME_DEVICE);
        this.doSendAssertion(request, response, samlAuthenticationRequest, user);
    }

    private boolean incrementVerificationCodeRetry(SamlAuthenticationRequest samlAuthenticationRequest) {
        int retryVerificationCode = samlAuthenticationRequest.getRetryVerificationCode();
        samlAuthenticationRequest.setRetryVerificationCode(retryVerificationCode + 1);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        return retryVerificationCode > 2;
    }

    private boolean checkStepUp(HttpServletResponse response, HttpServletRequest request, String hash, SamlAuthenticationRequest samlAuthenticationRequest, User user, String charSet, String explanation) throws IOException {
        boolean missingLinkedInstitution;
        boolean inStepUpFlow = StepUpStatus.IN_STEP_UP.equals((Object)samlAuthenticationRequest.getSteppedUp());
        boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        boolean missingStudentAffiliation = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.AFFILIATION_STUDENT) && !hasStudentAffiliation;
        boolean missingValidName = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.VALIDATE_NAMES) && !GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
        Instant now = new Date().toInstant();
        boolean bl = missingLinkedInstitution = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.LINKED_INSTITUTION) && (CollectionUtils.isEmpty((Collection)user.getLinkedAccounts()) || user.getLinkedAccounts().stream().allMatch(linkedAccount -> now.isAfter(linkedAccount.getExpiresAt().toInstant())));
        if (user.isNewUser()) {
            user.setNewUser(false);
            this.userRepository.save((Object)user);
            MDCContext.logWithContext((User)user, (String)"add", (String)"account", (Log)LOG, (String)"Saving user after new registration and magic link");
            this.mailBox.sendAccountConfirmation(user);
            if (inStepUpFlow) {
                this.finishStepUp(samlAuthenticationRequest);
            }
            if (missingStudentAffiliation || missingValidName || missingLinkedInstitution) {
                return true;
            }
            if (samlAuthenticationRequest.isTiqrFlow()) {
                return true;
            }
            String url = this.redirectUrl + "/request-success?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
            response.sendRedirect(url);
            return false;
        }
        if (inStepUpFlow) {
            this.finishStepUp(samlAuthenticationRequest);
            if (missingStudentAffiliation || missingValidName || missingLinkedInstitution) {
                return true;
            }
            boolean externalNameValidation = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.VALIDATE_NAMES_EXTERNAL);
            String path = externalNameValidation ? "confirm-external-stepup" : "confirm-stepup";
            response.sendRedirect(this.redirectUrl + "/" + path + "?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet) + "&explanation=" + explanation + "&ref=" + user.getId());
            return false;
        }
        if (this.featureUseApp && !samlAuthenticationRequest.isPasswordOrWebAuthnFlow() && !samlAuthenticationRequest.isTiqrFlow() && !user.loginOptions().contains(LoginOptions.APP.getValue()) && user.nudgeToApp(this.nudgeAppDays, this.nudgeAppDelayDays)) {
            this.userRepository.save((Object)user);
            String url = this.redirectUrl + "/confirm?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet) + "&new=false";
            response.sendRedirect(url);
            return false;
        }
        if (!this.featureDefaultRememberMe && !samlAuthenticationRequest.isRememberMeQuestionAsked()) {
            samlAuthenticationRequest.setRememberMeQuestionAsked(true);
            this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
            if (CookieResolver.cookieByName((HttpServletRequest)request, (String)"REMEMBER_ME_QUESTION_ASKED_COOKIE").isPresent()) {
                return true;
            }
            this.addRememberMeQuestionAskedCookie(response);
            String url = this.redirectUrl + "/remember?h=" + hash + "&redirect=" + URLEncoder.encode(this.magicLinkUrl, charSet);
            response.sendRedirect(url);
            return false;
        }
        return true;
    }

    private void continueAfterLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String id = request.getParameter("id");
        Optional optionalSamlAuthenticationRequest = this.authenticationRequestRepository.findById((Object)id);
        if (!optionalSamlAuthenticationRequest.isPresent()) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        SamlAuthenticationRequest samlAuthenticationRequest = (SamlAuthenticationRequest)optionalSamlAuthenticationRequest.get();
        String verificationCode = request.getParameter("verificationCode");
        if (!StringUtils.hasText((String)verificationCode) || !verificationCode.equals(samlAuthenticationRequest.getVerificationCode())) {
            if (this.incrementVerificationCodeRetry(samlAuthenticationRequest)) {
                response.sendRedirect(this.redirectUrl + "/max-attempts");
                return;
            }
            String currentUrl = URLDecoder.decode(request.getParameter("currentUrl"), Charset.defaultCharset().name());
            response.sendRedirect(currentUrl + "&mismatch=true");
            return;
        }
        if (samlAuthenticationRequest.getLoginStatus().equals((Object)LoginStatus.NOT_LOGGED_IN)) {
            response.sendRedirect(this.redirectUrl + "/expired");
            return;
        }
        String userId = samlAuthenticationRequest.getUserId();
        User user = (User)this.userRepository.findById((Object)userId).orElseThrow(() -> new UserNotFoundException(userId));
        String charSet = Charset.defaultCharset().name();
        boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        String explanation = ACR.explanationKeyWord((List)authenticationContextClassReferences, (boolean)hasStudentAffiliation);
        boolean proceed = this.checkStepUp(response, request, samlAuthenticationRequest.getHash(), samlAuthenticationRequest, user, charSet, explanation);
        if (!proceed) {
            return;
        }
        this.doSendAssertion(request, response, samlAuthenticationRequest, user);
    }

    private void doSendAssertion(HttpServletRequest request, HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest, User user) {
        samlAuthenticationRequest.setHash(null);
        LOG.debug((Object)String.format("Disabling SAML authentication request after login by %s ", user.getUsername()));
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
        boolean mfaProfileRequired = samlAuthenticationRequest.isMfaProfileRequired();
        List<GrantedAuthority> authorities = user.getAuthorities();
        if (mfaProfileRequired && samlAuthenticationRequest.isTiqrFlow()) {
            authorities = List.of(new SimpleGrantedAuthority("ROLE_MFA"), (GrantedAuthority)authorities.iterator().next());
        }
        UserAuthenticationToken authentication = new UserAuthenticationToken((Object)user, null, (Collection)authorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        this.securityContextRepository.saveContext(SecurityContextHolder.getContext(), request, response);
        if (this.featureDefaultRememberMe) {
            LOG.info((Object)String.format("Remember me functionality activated for %s ", user.getUsername()));
            this.addRememberMeCookie(response, samlAuthenticationRequest);
        }
        if (samlAuthenticationRequest.isTiqrFlow()) {
            LOG.info((Object)String.format("Tiqr flow authenticated for %s ", user.getUsername()));
            this.addTiqrCookie(response, user);
        }
        this.sendAssertion(request, response, samlAuthenticationRequest, user);
    }

    private void finishStepUp(SamlAuthenticationRequest samlAuthenticationRequest) {
        samlAuthenticationRequest.setSteppedUp(StepUpStatus.FINISHED_STEP_UP);
        this.authenticationRequestRepository.save((Object)samlAuthenticationRequest);
    }

    private void addRememberMeCookie(HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest) {
        Cookie cookie = new Cookie("guest-idp-remember-me", samlAuthenticationRequest.getRememberMeValue());
        cookie.setMaxAge(this.rememberMeMaxAge);
        cookie.setSecure(this.secureCookie);
        cookie.setHttpOnly(true);
        response.addCookie(cookie);
    }

    private void addTiqrCookie(HttpServletResponse response, User user) {
        Cookie cookie = new Cookie("TIQR_COOKIE", this.cookieValueEncoder.encode(user.getUsername()));
        cookie.setMaxAge(this.tiqrCookieMaxAge);
        cookie.setSecure(this.secureCookie);
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    private void addRememberMeQuestionAskedCookie(HttpServletResponse response) {
        Cookie cookie = new Cookie("REMEMBER_ME_QUESTION_ASKED_COOKIE", Boolean.TRUE.toString());
        cookie.setMaxAge(this.rememberMeQuestionAskedDays * 60 * 60 * 24);
        cookie.setSecure(this.secureCookie);
        cookie.setHttpOnly(true);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    private void addTrackingCookie(HttpServletRequest request, HttpServletResponse response, User user) {
        Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"TRACKING_DEVICE");
        boolean existingUser = StringUtils.hasText((String)user.getTrackingUuid());
        if (!existingUser) {
            user.setTrackingUuid(UUID.randomUUID().toString());
            this.userRepository.save((Object)user);
        }
        if (!optionalCookie.isPresent() || !user.getTrackingUuid().equalsIgnoreCase(((Cookie)optionalCookie.get()).getValue())) {
            Cookie cookie = new Cookie("TRACKING_DEVICE", user.getTrackingUuid());
            cookie.setMaxAge(0x7FFFFFFE);
            cookie.setSecure(this.secureCookie);
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
            Map<String, String> headers = Collections.list(request.getHeaderNames()).stream().collect(Collectors.toMap(s -> s, arg_0 -> ((HttpServletRequest)request).getHeader(arg_0)));
            headers.put("ipAddress", request.getRemoteAddr());
            this.executor.submit(() -> {
                UserLogin userLogin = new UserLogin(user, headers);
                String lookupAddress = userLogin.getLookupAddress();
                Optional optionalLocation = this.geoLocation.findLocation(lookupAddress);
                optionalLocation.ifPresent(location -> userLogin.setIpLocation(location));
                this.userLoginRepository.save((Object)userLogin);
                if (existingUser) {
                    this.mailBox.sendNewDevice(user, userLogin);
                }
            });
        }
    }

    private void sendAssertion(HttpServletRequest request, HttpServletResponse response, SamlAuthenticationRequest samlAuthenticationRequest, User user) {
        String relayState = samlAuthenticationRequest.getRelayState();
        String requesterEntityId = samlAuthenticationRequest.getRequesterEntityId();
        List authenticationContextClassReferences = samlAuthenticationRequest.getAuthenticationContextClassReferences();
        List attributes = this.attributes(user, requesterEntityId);
        boolean applySsoMfa = this.isApplySsoMfa();
        SAMLStatus samlStatus = SAMLStatus.SUCCESS;
        String optionalMessage = null;
        String authnContextClassRefValue = "urn:oasis:names:tc:SAML:2.0:ac:classes:Password";
        if (samlAuthenticationRequest.isAccountLinkingRequired()) {
            boolean missingLinkedInstitution;
            boolean hasStudentAffiliation = GuestIdpAuthenticationRequestFilter.hasRequiredStudentAffiliation((List)user.allEduPersonAffiliations());
            boolean missingStudentAffiliation = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.AFFILIATION_STUDENT) && !hasStudentAffiliation;
            boolean missingValidName = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.VALIDATE_NAMES) && !GuestIdpAuthenticationRequestFilter.hasValidatedName((User)user);
            boolean missingExternalName = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.VALIDATE_NAMES_EXTERNAL) && !GuestIdpAuthenticationRequestFilter.hasValidatedExternalName((User)user);
            Instant now = new Date().toInstant();
            boolean bl = missingLinkedInstitution = ACR.containsAcr((List)authenticationContextClassReferences, (String)ACR.LINKED_INSTITUTION) && (CollectionUtils.isEmpty((Collection)user.getLinkedAccounts()) || user.getLinkedAccounts().stream().allMatch(linkedAccount -> now.isAfter(linkedAccount.getExpiresAt().toInstant())));
            if (missingStudentAffiliation || missingValidName || missingExternalName || missingLinkedInstitution) {
                optionalMessage = missingValidName ? "The requesting service has indicated that the authenticated user is required to have a first_name and last_name. Your institution has not provided those attributes." : (missingExternalName ? "The requesting service has indicated that the authenticated user has verified their first_name and last_name. Your identity is not verified by an external trusted party." : (missingLinkedInstitution ? "The requesting service has indicated that the authenticated user has linked its account to an Institution. Your identity is not verified by an external educational institution." : "The requesting service has indicated that the authenticated user is required to have an affiliation Student. Your institution has not provided this affiliation."));
                samlStatus = SAMLStatus.NO_AUTHN_CONTEXT;
            } else {
                authnContextClassRefValue = ACR.selectACR((List)authenticationContextClassReferences, (boolean)hasStudentAffiliation);
            }
        } else if (samlAuthenticationRequest.isMfaProfileRequired()) {
            if (samlAuthenticationRequest.isTiqrFlow() || applySsoMfa) {
                authnContextClassRefValue = ACR.selectACR((List)authenticationContextClassReferences, (boolean)false);
            } else {
                optionalMessage = "The requesting service has indicated that a login with the eduID app is required to login.";
                samlStatus = SAMLStatus.NO_AUTHN_CONTEXT;
            }
        } else if (!applySsoMfa && !CollectionUtils.isEmpty((Collection)authenticationContextClassReferences)) {
            optionalMessage = String.format("The specified authentication context requirements '%s' cannot be met by the responder.", String.join((CharSequence)", ", authenticationContextClassReferences));
            samlStatus = SAMLStatus.NO_AUTHN_CONTEXT;
        }
        if (!samlStatus.equals((Object)SAMLStatus.SUCCESS)) {
            authnContextClassRefValue = "urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified";
        }
        Optional optionalCookie = CookieResolver.cookieByName((HttpServletRequest)request, (String)"BROWSER_SESSION");
        optionalCookie.ifPresent(cookie -> {
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        });
        this.addTrackingCookie(request, response, user);
        String loginMethod = samlAuthenticationRequest.isTiqrFlow() ? "tiqr" : (samlAuthenticationRequest.isOneTimeLoginCodeFlow() ? "one_time_login_code" : (samlAuthenticationRequest.isPasswordOrWebAuthnFlow() ? "password" : "cookie"));
        MDCContext.logLoginWithContext((User)user, (String)loginMethod, (boolean)true, (Log)LOG, (String)("Successfully logged in with " + loginMethod), (HttpServletRequest)request, (String)authnContextClassRefValue, (List)authenticationContextClassReferences);
        this.samlService.sendResponse(samlAuthenticationRequest.getIssuer(), samlAuthenticationRequest.getRequestId(), user.getUid(), samlStatus, relayState, optionalMessage, authnContextClassRefValue, attributes, response);
    }

    protected List<SAMLAttribute> attributes(User user, String requesterEntityId) {
        List linkedAccounts = this.safeSortedAffiliations(user);
        String givenName = user.getDerivedGivenName();
        String familyName = user.getDerivedFamilyName();
        String chosenName = user.getChosenName();
        if (!StringUtils.hasText((String)chosenName)) {
            chosenName = givenName;
            user.setChosenName(chosenName);
        }
        if (!StringUtils.hasText((String)givenName)) {
            givenName = chosenName;
        }
        String displayName = String.format("%s %s", chosenName, familyName);
        String eppn = user.getEduPersonPrincipalName();
        ArrayList<SAMLAttribute> attributes = new ArrayList<SAMLAttribute>(Arrays.asList(this.attribute("urn:mace:dir:attribute-def:cn", displayName), this.attribute("urn:mace:dir:attribute-def:displayName", displayName), this.attribute("urn:mace:dir:attribute-def:eduPersonPrincipalName", eppn), this.attribute("urn:oasis:names:tc:SAML:attribute:subject-id", eppn), this.attribute("urn:mace:dir:attribute-def:givenName", givenName), this.attribute("urn:mace:dir:attribute-def:mail", user.getEmail()), this.attribute("urn:mace:dir:attribute-def:sn", familyName), this.attribute("urn:mace:dir:attribute-def:uid", user.getUid()), this.attribute("urn:mace:terena.org:attribute-def:schacHomeOrganization", user.getSchacHomeOrganization())));
        String eduIDValue = user.computeEduIdForServiceProviderIfAbsent(requesterEntityId, this.manage);
        this.userRepository.save((Object)user);
        if (StringUtils.hasText((String)user.getPreferredLanguage())) {
            attributes.add(this.attribute("urn:mace:dir:attribute-def:preferredLanguage", user.getPreferredLanguage()));
        }
        attributes.add(this.attribute("urn:mace:eduid.nl:1.1", eduIDValue));
        if (user.getDerivedDateOfBirth() != null) {
            String dateOfBirth = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.systemDefault()).format(user.getDerivedDateOfBirth().toInstant());
            attributes.add(this.attribute("urn:schac:attribute-def:schacDateOfBirth", dateOfBirth));
        }
        user.getAttributes().forEach((key, values) -> values.forEach(value -> attributes.add(this.attribute(key, value))));
        ArrayList scopedAffiliations = new ArrayList(linkedAccounts.stream().map(linkedAccount -> linkedAccount.getEduPersonAffiliations().stream().map(affiliation -> affiliation.contains("@") ? affiliation : String.format("%s@%s", affiliation, linkedAccount.getSchacHomeOrganization())).collect(Collectors.toList())).flatMap(Collection::stream).distinct().toList());
        if (this.featureDefaultAffiliateEmail) {
            LOG.debug((Object)String.format("Default affiliate me functionality activated for %s ", user.getUsername()));
            scopedAffiliations.add(String.format("affiliate@%s", this.defaultAffiliateEmailDomain));
        }
        scopedAffiliations.forEach(aff -> attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonScopedAffiliation", aff)));
        scopedAffiliations.stream().map(affiliation -> affiliation.substring(0, affiliation.indexOf("@"))).distinct().forEach(aff -> attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonAffiliation", aff)));
        List studentAffiliations = user.getExternalLinkedAccounts().stream().map(ExternalLinkedAccount::getAffiliations).filter(externalLinkedAccountAffiliations -> !CollectionUtils.isEmpty((Collection)externalLinkedAccountAffiliations)).flatMap(Collection::stream).distinct().toList();
        studentAffiliations.forEach(aff -> attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonScopedAffiliation", aff)));
        if (!studentAffiliations.isEmpty() && attributes.stream().noneMatch(samlAttribute -> samlAttribute.getName().equals("urn:mace:dir:attribute-def:eduPersonAffiliation") && samlAttribute.getValue().equals("student"))) {
            attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonAffiliation", "student"));
        }
        List eduPersonAssurances = this.eduPersonAssurances(user);
        eduPersonAssurances.forEach(eduPersonAssurance -> attributes.add(this.attribute("urn:mace:dir:attribute-def:eduPersonAssurance", eduPersonAssurance)));
        return attributes;
    }

    private List<String> eduPersonAssurances(User user) {
        List externalLinkedAccounts;
        List linkedAccounts = user.getLinkedAccounts();
        List<String> eduPersonAssuranceIdP = linkedAccounts.stream().map(LinkedAccount::getEduPersonAssurances).flatMap(Collection::stream).map(String::toLowerCase).toList();
        ArrayList<String> eduPersonAssurances = new ArrayList<String>();
        if (!linkedAccounts.isEmpty()) {
            if (eduPersonAssuranceIdP.stream().noneMatch(ass -> ass.startsWith("https://refeds.org/assurance/iap/"))) {
                eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
                eduPersonAssurances.add("https://eduid.nl/validated/institution");
            } else if (eduPersonAssuranceIdP.stream().anyMatch(ass -> ass.equals("https://refeds.org/assurance/iap/medium"))) {
                eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
                eduPersonAssurances.add("https://eduid.nl/validated/institution");
            } else if (eduPersonAssuranceIdP.stream().anyMatch(ass -> ass.equals("https://refeds.org/assurance/iap/high"))) {
                eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
                eduPersonAssurances.add("https://refeds.org/assurance/IAP/high");
                eduPersonAssurances.add("https://eduid.nl/validated/institution");
            }
        }
        if ((externalLinkedAccounts = user.getExternalLinkedAccounts()).stream().anyMatch(acc -> acc.getIdpScoping().equals((Object)IdpScoping.idin))) {
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/high");
            eduPersonAssurances.add("https://eduid.nl/validated/bank");
        }
        if (externalLinkedAccounts.stream().anyMatch(acc -> acc.getIdpScoping().equals((Object)IdpScoping.eherkenning))) {
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/high");
            eduPersonAssurances.add("https://eduid.nl/validated/eidas");
        }
        if (externalLinkedAccounts.stream().anyMatch(acc -> acc.getIdpScoping().equals((Object)IdpScoping.serviceDesk))) {
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/high");
            eduPersonAssurances.add("https://eduid.nl/validated/servicedesk");
        }
        externalLinkedAccounts.stream().filter(acc -> acc.getIdpScoping().equals((Object)IdpScoping.studielink) && acc.getVerification() != null && !acc.getVerification().equals((Object)Verification.Ongeverifieerd)).findFirst().ifPresent(acc -> {
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
            if (acc.getVerification().equals((Object)Verification.Geverifieerd)) {
                eduPersonAssurances.add("https://refeds.org/assurance/IAP/high");
                eduPersonAssurances.add("https://eduid.nl/validated/central-enrollment/G");
            } else if (acc.getVerification().equals((Object)Verification.Verifai)) {
                eduPersonAssurances.add("https://eduid.nl/validated/central-enrollment/V");
            } else if (acc.getVerification().equals((Object)Verification.Decentraal)) {
                eduPersonAssurances.add("https://eduid.nl/validated/central-enrollment/D");
            }
        });
        if (externalLinkedAccounts.stream().anyMatch(acc -> acc.getIdpScoping().equals((Object)IdpScoping.serviceDesk))) {
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/medium");
            eduPersonAssurances.add("https://refeds.org/assurance/IAP/high");
            eduPersonAssurances.add("https://eduid.nl/validated/servicedesk");
        }
        eduPersonAssurances.addAll(List.of("https://refeds.org/assurance", "https://refeds.org/assurance/ID/unique", "https://refeds.org/assurance/ID/eppn-unique-no-reassign", "https://refeds.org/assurance/IAP/low", "https://refeds.org/assurance/version/2", "https://eduid.nl/validated/email-validated"));
        return eduPersonAssurances.stream().distinct().toList();
    }

    private List<LinkedAccount> safeSortedAffiliations(User user) {
        List linkedAccounts = user.linkedAccountsSorted();
        List<LinkedAccount> linkedAccountsEmptyAffiliations = linkedAccounts.stream().filter(linkedAccount -> CollectionUtils.isEmpty((Collection)linkedAccount.getEduPersonAffiliations())).collect(Collectors.toList());
        linkedAccountsEmptyAffiliations.forEach(linkedAccount -> linkedAccount.setEduPersonAffiliations(Collections.singletonList("affiliation@" + linkedAccount.getSchacHomeOrganization())));
        if (!linkedAccountsEmptyAffiliations.isEmpty()) {
            this.userRepository.save((Object)user);
        }
        return user.linkedAccountsSorted();
    }

    private SAMLAttribute attribute(String name, String value) {
        return new SAMLAttribute(name, value);
    }

    private void metaData(HttpServletResponse servletResponse) throws IOException {
        servletResponse.setContentType("text/xml");
        servletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        servletResponse.setHeader("Cache-Control", "private");
        String metaData = this.samlService.metaData(this.identityProviderMetaData.getSingleSignOnServiceURI(), this.identityProviderMetaData.getName(), this.identityProviderMetaData.getDescription(), this.identityProviderMetaData.getLogoURI());
        servletResponse.getWriter().write(metaData);
    }

    @Generated
    public GuestIdpAuthenticationRequestFilter() {
        this.ssoSamlRequestMatcher = null;
        this.magicSamlRequestMatcher = null;
        this.continueAfterLoginSamlRequestMatcher = null;
        this.metaDataSamlRequestMatcher = null;
        this.redirectUrl = null;
        this.authenticationRequestRepository = null;
        this.identityProviderMetaData = null;
        this.securityContextRepository = null;
        this.userLoginRepository = null;
        this.accountLinkingContextClassReferences = null;
        this.geoLocation = null;
        this.rememberMeMaxAge = 0;
        this.tiqrCookieMaxAge = 0;
        this.secureCookie = false;
        this.magicLinkUrl = null;
        this.mailBox = null;
        this.executor = null;
        this.nudgeAppDays = 0;
        this.nudgeAppDelayDays = 0;
        this.rememberMeQuestionAskedDays = 0;
        this.expiryNonValidatedDurationDays = 0L;
        this.ssoMFADurationSeconds = 0L;
        this.mobileAppROEntityId = null;
        this.featureDefaultRememberMe = false;
        this.featureDefaultAffiliateEmail = false;
        this.featureUseApp = false;
        this.defaultAffiliateEmailDomain = null;
        this.samlService = null;
        this.cookieValueEncoder = null;
    }

    @Generated
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Generated
    public void setManage(Manage manage) {
        this.manage = manage;
    }

    @Generated
    public Manage getManage() {
        return this.manage;
    }
}

