/*
 * Decompiled with CFR 0.152.
 */
package oidc.secure;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import oidc.model.AccessToken;
import oidc.model.RefreshToken;
import oidc.model.SigningKey;
import oidc.model.SymmetricKey;
import oidc.secure.TokenGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class KeyRollover {
    private static final Log LOG = LogFactory.getLog(KeyRollover.class);
    private final TokenGenerator tokenGenerator;
    private final MongoTemplate mongoTemplate;
    private final boolean cronJobResponsible;

    public KeyRollover(TokenGenerator tokenGenerator, MongoTemplate mongoTemplate, @Value(value="${cron.node-cron-job-responsible}") boolean cronJobResponsible) {
        this.tokenGenerator = tokenGenerator;
        this.mongoTemplate = mongoTemplate;
        this.cronJobResponsible = cronJobResponsible;
    }

    @Scheduled(cron="${cron.key-rollover-expression}")
    public void rollover() {
        if (!this.cronJobResponsible) {
            return;
        }
        this.doSigningKeyRollover();
    }

    public List<String> doSigningKeyRollover() {
        try {
            SigningKey signingKey = this.tokenGenerator.rolloverSigningKeys();
            LOG.info((Object)("Successful signing key rollover. New signing key: " + signingKey.getKeyId()));
            return this.cleanUpSigningKeys(signingKey);
        }
        catch (Exception e) {
            LOG.error((Object)"Rollover exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<String> doSymmetricKeyRollover() {
        try {
            SymmetricKey symmetricKey = this.tokenGenerator.rolloverSymmetricKeys();
            LOG.info((Object)("Successful symmetric key rollover. New symmetric key: " + symmetricKey.getKeyId()));
            return this.cleanUpSymmetricKeys(symmetricKey);
        }
        catch (Exception e) {
            LOG.error((Object)"Rollover exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> cleanUpSigningKeys(SigningKey signingKey) {
        List signingKeyValues = this.mongoTemplate.findDistinct("signingKeyId", AccessToken.class, String.class);
        List signingKeyValuesRefreshToken = this.mongoTemplate.findDistinct("signingKeyId", RefreshToken.class, String.class);
        signingKeyValues.addAll(signingKeyValuesRefreshToken);
        signingKeyValues.add(signingKey.getKeyId());
        signingKeyValues.add(this.tokenGenerator.getCurrentSigningKeyId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"keyId").not().in((Collection)signingKeyValues));
        List signingKeys = this.mongoTemplate.findAllAndRemove(query, SigningKey.class);
        List<String> deleted = signingKeys.stream().map(SigningKey::getKeyId).collect(Collectors.toList());
        String deletedKeys = deleted.isEmpty() ? "None" : String.join((CharSequence)", ", deleted);
        LOG.info((Object)("Deleted signing keys that are no longer referenced by access_tokens and refresh_token: " + deletedKeys));
        return deleted;
    }

    private List<String> cleanUpSymmetricKeys(SymmetricKey symmetricKey) {
        List symmetricKeyValues = this.mongoTemplate.findDistinct("symmetricKeyId", SigningKey.class, String.class);
        symmetricKeyValues.add(symmetricKey.getKeyId());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"keyId").not().in((Collection)symmetricKeyValues));
        List symmetricKeys = this.mongoTemplate.findAllAndRemove(query, SymmetricKey.class);
        List<String> deleted = symmetricKeys.stream().map(SymmetricKey::getKeyId).collect(Collectors.toList());
        String deletedKeys = deleted.isEmpty() ? "None" : String.join((CharSequence)", ", deleted);
        LOG.info((Object)("Deleted symmetric keys that are no longer referenced by signing keys: " + deletedKeys));
        return deleted;
    }
}

