/*
 * Decompiled with CFR 0.152.
 */
package oidc.endpoints;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.JsonKeysetWriter;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.KeysetWriter;
import com.google.crypto.tink.aead.AesCtrHmacAeadKeyManager;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.ParseException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oidc.endpoints.MapTypeReference;
import oidc.secure.TokenGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class JwkKeysEndpoint
implements MapTypeReference {
    private final TokenGenerator tokenGenerator;
    private final ObjectMapper objectMapper;
    private final Map<String, Object> wellKnownConfiguration;
    private final Long maxAge;

    public JwkKeysEndpoint(TokenGenerator tokenGenerator, ObjectMapper objectMapper, @Value(value="${keys-cache.cache-duration-seconds}") Long maxAge, @Value(value="${openid_configuration_path}") Resource configurationPath) throws IOException {
        this.tokenGenerator = tokenGenerator;
        this.wellKnownConfiguration = (Map)objectMapper.readValue(configurationPath.getInputStream(), mapTypeReference);
        this.objectMapper = objectMapper;
        this.maxAge = maxAge;
    }

    @GetMapping(value={"/oidc/certs"}, produces={"application/json"})
    public ResponseEntity<String> publishClientJwk() throws GeneralSecurityException, ParseException, IOException {
        String publicKeysJson = this.objectMapper.writeValueAsString((Object)new JWKSet(this.tokenGenerator.getAllPublicKeys()).toJSONObject());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setCacheControl(CacheControl.maxAge((long)this.maxAge, (TimeUnit)TimeUnit.SECONDS).noTransform());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(responseHeaders)).body((Object)publicKeysJson);
    }

    @GetMapping(value={"oidc/generate-secret-key-set"})
    public Map<String, Object> generateSymmetricSecretKey() throws GeneralSecurityException, IOException {
        KeysetHandle keysetHandle = KeysetHandle.generateNew((KeyTemplate)AesCtrHmacAeadKeyManager.aes256CtrHmacSha256Template());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CleartextKeysetHandle.write((KeysetHandle)keysetHandle, (KeysetWriter)JsonKeysetWriter.withOutputStream((OutputStream)outputStream));
        return (Map)this.objectMapper.readValue(outputStream.toString(), mapTypeReference);
    }

    @GetMapping(value={"oidc/.well-known/openid-configuration", ".well-known/openid-configuration"})
    public ResponseEntity<Map<String, Object>> wellKnownConfiguration() {
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.OK).cacheControl(CacheControl.maxAge((long)4L, (TimeUnit)TimeUnit.HOURS).noTransform())).body((Object)this.wellKnownConfiguration);
    }
}

