/*
 * Decompiled with CFR 0.152.
 */
package pdp.access;

import java.util.Collection;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public class BasicAuthenticationProvider
implements AuthenticationProvider {
    private static final Collection<? extends GrantedAuthority> API_AUTHORITIES = AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER", "ROLE_PEP"});
    private final String userName;
    private final String password;

    public BasicAuthenticationProvider(String userName, String password) {
        Assert.notNull((Object)userName, (String)"Username must not be null");
        Assert.notNull((Object)password, (String)"Password must not be null");
        this.userName = userName;
        this.password = password;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.userName.equals(authentication.getPrincipal())) {
            throw new UsernameNotFoundException("Unknown user: " + String.valueOf(authentication.getPrincipal()));
        }
        if (!this.password.equals(authentication.getCredentials())) {
            throw new BadCredentialsException("Bad credentials");
        }
        return new UsernamePasswordAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), API_AUTHORITIES);
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

