/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.util.CollectionUtils;
import pdp.domain.LoA;
import pdp.domain.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PdpPolicyDefinition {
    private String id;
    private String policyId;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String name;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String description;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) List<String> serviceProviderIds = new ArrayList();
    private List<String> serviceProviderNames = new ArrayList();
    private List<String> serviceProviderNamesNl = new ArrayList();
    private boolean serviceProviderInvalidOrMissing;
    private List<String> identityProviderIds = new ArrayList();
    private List<String> identityProviderNames = new ArrayList();
    private List<String> identityProviderNamesNl = new ArrayList();
    private String clientId;
    @Valid
    private List<PdpAttribute> attributes = new ArrayList();
    @Valid
    private List<LoA> loas = new ArrayList();
    private String denyAdvice;
    private boolean denyRule;
    private boolean allAttributesMustMatch;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private Date created;
    private String userDisplayName;
    private String authenticatingAuthorityName;
    private int numberOfViolations;
    private int numberOfRevisions;
    private String denyAdviceNl;
    private int revisionNbr;
    private boolean isActivatedSr;
    private boolean active;
    private boolean actionsAllowed;
    private String type;
    private Long parentId;

    @JsonIgnore
    public List<String> anyIdentityProviders() {
        return CollectionUtils.isEmpty((Collection)this.identityProviderIds) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public Set<Map.Entry<String, List<PdpAttribute>>> allAttributesGrouped() {
        return this.attributes.stream().collect(Collectors.groupingBy(PdpAttribute::getName)).entrySet();
    }

    @JsonIgnore
    public boolean isIdpOnly() {
        return this.identityProviderIds != null && !this.identityProviderIds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdpPolicyDefinition that = (PdpPolicyDefinition)o;
        return Objects.equals(this.denyRule, that.denyRule) && Objects.equals(this.allAttributesMustMatch, that.allAttributesMustMatch) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.serviceProviderIds, that.serviceProviderIds) && Objects.equals(this.identityProviderIds, that.identityProviderIds) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.denyAdvice, that.denyAdvice) && Objects.equals(this.denyAdviceNl, that.denyAdviceNl);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.serviceProviderIds, this.identityProviderIds, this.attributes, this.denyAdvice, this.denyRule, this.allAttributesMustMatch);
    }

    public static PdpPolicyDefinition policyDefinition(List<String> serviceProviderIds, List<String> identityProvidersIds) {
        PdpPolicyDefinition definition = new PdpPolicyDefinition();
        definition.setServiceProviderIds(serviceProviderIds);
        definition.setServiceProviderNames(serviceProviderIds);
        definition.setIdentityProviderIds(identityProvidersIds);
        definition.setType("reg");
        return definition;
    }

    @JsonIgnore
    public void sortLoas() {
        Collections.sort(this.loas, Comparator.comparing(LoA::getLevel).reversed());
    }

    @JsonIgnore
    public void sortAttributes() {
        Collections.sort(this.attributes, Comparator.comparing(PdpAttribute::getName));
    }

    public String getId() {
        return this.id;
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getServiceProviderIds() {
        return this.serviceProviderIds;
    }

    public List<String> getServiceProviderNames() {
        return this.serviceProviderNames;
    }

    public List<String> getServiceProviderNamesNl() {
        return this.serviceProviderNamesNl;
    }

    public boolean isServiceProviderInvalidOrMissing() {
        return this.serviceProviderInvalidOrMissing;
    }

    public List<String> getIdentityProviderIds() {
        return this.identityProviderIds;
    }

    public List<String> getIdentityProviderNames() {
        return this.identityProviderNames;
    }

    public List<String> getIdentityProviderNamesNl() {
        return this.identityProviderNamesNl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    public List<LoA> getLoas() {
        return this.loas;
    }

    public String getDenyAdvice() {
        return this.denyAdvice;
    }

    public boolean isDenyRule() {
        return this.denyRule;
    }

    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public String getAuthenticatingAuthorityName() {
        return this.authenticatingAuthorityName;
    }

    public int getNumberOfViolations() {
        return this.numberOfViolations;
    }

    public int getNumberOfRevisions() {
        return this.numberOfRevisions;
    }

    public String getDenyAdviceNl() {
        return this.denyAdviceNl;
    }

    public int getRevisionNbr() {
        return this.revisionNbr;
    }

    public boolean isActivatedSr() {
        return this.isActivatedSr;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isActionsAllowed() {
        return this.actionsAllowed;
    }

    public String getType() {
        return this.type;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setServiceProviderIds(List<String> serviceProviderIds) {
        this.serviceProviderIds = serviceProviderIds;
    }

    public void setServiceProviderNames(List<String> serviceProviderNames) {
        this.serviceProviderNames = serviceProviderNames;
    }

    public void setServiceProviderNamesNl(List<String> serviceProviderNamesNl) {
        this.serviceProviderNamesNl = serviceProviderNamesNl;
    }

    public void setServiceProviderInvalidOrMissing(boolean serviceProviderInvalidOrMissing) {
        this.serviceProviderInvalidOrMissing = serviceProviderInvalidOrMissing;
    }

    public void setIdentityProviderIds(List<String> identityProviderIds) {
        this.identityProviderIds = identityProviderIds;
    }

    public void setIdentityProviderNames(List<String> identityProviderNames) {
        this.identityProviderNames = identityProviderNames;
    }

    public void setIdentityProviderNamesNl(List<String> identityProviderNamesNl) {
        this.identityProviderNamesNl = identityProviderNamesNl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    public void setLoas(List<LoA> loas) {
        this.loas = loas;
    }

    public void setDenyAdvice(String denyAdvice) {
        this.denyAdvice = denyAdvice;
    }

    public void setDenyRule(boolean denyRule) {
        this.denyRule = denyRule;
    }

    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public void setCreated(Date created) {
        this.created = created;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public void setAuthenticatingAuthorityName(String authenticatingAuthorityName) {
        this.authenticatingAuthorityName = authenticatingAuthorityName;
    }

    public void setNumberOfViolations(int numberOfViolations) {
        this.numberOfViolations = numberOfViolations;
    }

    public void setNumberOfRevisions(int numberOfRevisions) {
        this.numberOfRevisions = numberOfRevisions;
    }

    public void setDenyAdviceNl(String denyAdviceNl) {
        this.denyAdviceNl = denyAdviceNl;
    }

    public void setRevisionNbr(int revisionNbr) {
        this.revisionNbr = revisionNbr;
    }

    public void setActivatedSr(boolean isActivatedSr) {
        this.isActivatedSr = isActivatedSr;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setActionsAllowed(boolean actionsAllowed) {
        this.actionsAllowed = actionsAllowed;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String toString() {
        return "PdpPolicyDefinition(id=" + this.getId() + ", policyId=" + this.getPolicyId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", serviceProviderIds=" + String.valueOf(this.getServiceProviderIds()) + ", serviceProviderNames=" + String.valueOf(this.getServiceProviderNames()) + ", serviceProviderNamesNl=" + String.valueOf(this.getServiceProviderNamesNl()) + ", serviceProviderInvalidOrMissing=" + this.isServiceProviderInvalidOrMissing() + ", identityProviderIds=" + String.valueOf(this.getIdentityProviderIds()) + ", identityProviderNames=" + String.valueOf(this.getIdentityProviderNames()) + ", identityProviderNamesNl=" + String.valueOf(this.getIdentityProviderNamesNl()) + ", clientId=" + this.getClientId() + ", attributes=" + String.valueOf(this.getAttributes()) + ", loas=" + String.valueOf(this.getLoas()) + ", denyAdvice=" + this.getDenyAdvice() + ", denyRule=" + this.isDenyRule() + ", allAttributesMustMatch=" + this.isAllAttributesMustMatch() + ", created=" + String.valueOf(this.getCreated()) + ", userDisplayName=" + this.getUserDisplayName() + ", authenticatingAuthorityName=" + this.getAuthenticatingAuthorityName() + ", numberOfViolations=" + this.getNumberOfViolations() + ", numberOfRevisions=" + this.getNumberOfRevisions() + ", denyAdviceNl=" + this.getDenyAdviceNl() + ", revisionNbr=" + this.getRevisionNbr() + ", isActivatedSr=" + this.isActivatedSr() + ", active=" + this.isActive() + ", actionsAllowed=" + this.isActionsAllowed() + ", type=" + this.getType() + ", parentId=" + this.getParentId() + ")";
    }
}

