/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.util.CollectionUtils;
import pdp.domain.LoA;
import pdp.domain.PdpAttribute;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PdpPolicyDefinition {
    private String id;
    private String policyId;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String name;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) String description;
    @NotNull
    @Size(min=1)
    private @NotNull @Size(min=1) List<String> serviceProviderIds = new ArrayList();
    private List<String> serviceProviderNames = new ArrayList();
    private List<String> serviceProviderNamesNl = new ArrayList();
    private boolean serviceProviderInvalidOrMissing;
    private List<String> identityProviderIds = new ArrayList();
    private List<String> identityProviderNames = new ArrayList();
    private List<String> identityProviderNamesNl = new ArrayList();
    private String clientId;
    @Valid
    private List<PdpAttribute> attributes = new ArrayList();
    @Valid
    private List<LoA> loas = new ArrayList();
    private String denyAdvice;
    private boolean denyRule;
    private boolean allAttributesMustMatch;
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    private Date created;
    private String userDisplayName;
    private String authenticatingAuthorityName;
    private int numberOfViolations;
    private int numberOfRevisions;
    private String denyAdviceNl;
    private int revisionNbr;
    private boolean isActivatedSr;
    private boolean active;
    private boolean actionsAllowed;
    private String type;
    private Long parentId;

    @JsonIgnore
    public List<String> anyIdentityProviders() {
        return CollectionUtils.isEmpty((Collection)this.identityProviderIds) ? Collections.emptyList() : Arrays.asList("will-iterate-once");
    }

    @JsonIgnore
    public Set<Map.Entry<String, List<PdpAttribute>>> allAttributesGrouped() {
        return this.attributes.stream().collect(Collectors.groupingBy(PdpAttribute::getName)).entrySet();
    }

    @JsonIgnore
    public boolean isIdpOnly() {
        return this.identityProviderIds != null && !this.identityProviderIds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdpPolicyDefinition that = (PdpPolicyDefinition)o;
        return Objects.equals(this.denyRule, that.denyRule) && Objects.equals(this.allAttributesMustMatch, that.allAttributesMustMatch) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.serviceProviderIds, that.serviceProviderIds) && Objects.equals(this.identityProviderIds, that.identityProviderIds) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.denyAdvice, that.denyAdvice) && Objects.equals(this.denyAdviceNl, that.denyAdviceNl);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.serviceProviderIds, this.identityProviderIds, this.attributes, this.denyAdvice, this.denyRule, this.allAttributesMustMatch);
    }

    public static PdpPolicyDefinition policyDefinition(List<String> serviceProviderIds, List<String> identityProvidersIds) {
        PdpPolicyDefinition definition = new PdpPolicyDefinition();
        definition.setServiceProviderIds(serviceProviderIds);
        definition.setServiceProviderNames(serviceProviderIds);
        definition.setIdentityProviderIds(identityProvidersIds);
        definition.setType("reg");
        return definition;
    }

    @JsonIgnore
    public void sortLoas() {
        Collections.sort(this.loas, Comparator.comparing(LoA::getLevel).reversed());
    }

    @JsonIgnore
    public void sortAttributes() {
        Collections.sort(this.attributes, Comparator.comparing(PdpAttribute::getName));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getPolicyId() {
        return this.policyId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getServiceProviderIds() {
        return this.serviceProviderIds;
    }

    @Generated
    public List<String> getServiceProviderNames() {
        return this.serviceProviderNames;
    }

    @Generated
    public List<String> getServiceProviderNamesNl() {
        return this.serviceProviderNamesNl;
    }

    @Generated
    public boolean isServiceProviderInvalidOrMissing() {
        return this.serviceProviderInvalidOrMissing;
    }

    @Generated
    public List<String> getIdentityProviderIds() {
        return this.identityProviderIds;
    }

    @Generated
    public List<String> getIdentityProviderNames() {
        return this.identityProviderNames;
    }

    @Generated
    public List<String> getIdentityProviderNamesNl() {
        return this.identityProviderNamesNl;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public List<PdpAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public List<LoA> getLoas() {
        return this.loas;
    }

    @Generated
    public String getDenyAdvice() {
        return this.denyAdvice;
    }

    @Generated
    public boolean isDenyRule() {
        return this.denyRule;
    }

    @Generated
    public boolean isAllAttributesMustMatch() {
        return this.allAttributesMustMatch;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public String getAuthenticatingAuthorityName() {
        return this.authenticatingAuthorityName;
    }

    @Generated
    public int getNumberOfViolations() {
        return this.numberOfViolations;
    }

    @Generated
    public int getNumberOfRevisions() {
        return this.numberOfRevisions;
    }

    @Generated
    public String getDenyAdviceNl() {
        return this.denyAdviceNl;
    }

    @Generated
    public int getRevisionNbr() {
        return this.revisionNbr;
    }

    @Generated
    public boolean isActivatedSr() {
        return this.isActivatedSr;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public boolean isActionsAllowed() {
        return this.actionsAllowed;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Long getParentId() {
        return this.parentId;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setServiceProviderIds(List<String> serviceProviderIds) {
        this.serviceProviderIds = serviceProviderIds;
    }

    @Generated
    public void setServiceProviderNames(List<String> serviceProviderNames) {
        this.serviceProviderNames = serviceProviderNames;
    }

    @Generated
    public void setServiceProviderNamesNl(List<String> serviceProviderNamesNl) {
        this.serviceProviderNamesNl = serviceProviderNamesNl;
    }

    @Generated
    public void setServiceProviderInvalidOrMissing(boolean serviceProviderInvalidOrMissing) {
        this.serviceProviderInvalidOrMissing = serviceProviderInvalidOrMissing;
    }

    @Generated
    public void setIdentityProviderIds(List<String> identityProviderIds) {
        this.identityProviderIds = identityProviderIds;
    }

    @Generated
    public void setIdentityProviderNames(List<String> identityProviderNames) {
        this.identityProviderNames = identityProviderNames;
    }

    @Generated
    public void setIdentityProviderNamesNl(List<String> identityProviderNamesNl) {
        this.identityProviderNamesNl = identityProviderNamesNl;
    }

    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setAttributes(List<PdpAttribute> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setLoas(List<LoA> loas) {
        this.loas = loas;
    }

    @Generated
    public void setDenyAdvice(String denyAdvice) {
        this.denyAdvice = denyAdvice;
    }

    @Generated
    public void setDenyRule(boolean denyRule) {
        this.denyRule = denyRule;
    }

    @Generated
    public void setAllAttributesMustMatch(boolean allAttributesMustMatch) {
        this.allAttributesMustMatch = allAttributesMustMatch;
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setAuthenticatingAuthorityName(String authenticatingAuthorityName) {
        this.authenticatingAuthorityName = authenticatingAuthorityName;
    }

    @Generated
    public void setNumberOfViolations(int numberOfViolations) {
        this.numberOfViolations = numberOfViolations;
    }

    @Generated
    public void setNumberOfRevisions(int numberOfRevisions) {
        this.numberOfRevisions = numberOfRevisions;
    }

    @Generated
    public void setDenyAdviceNl(String denyAdviceNl) {
        this.denyAdviceNl = denyAdviceNl;
    }

    @Generated
    public void setRevisionNbr(int revisionNbr) {
        this.revisionNbr = revisionNbr;
    }

    @Generated
    public void setActivatedSr(boolean isActivatedSr) {
        this.isActivatedSr = isActivatedSr;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public void setActionsAllowed(boolean actionsAllowed) {
        this.actionsAllowed = actionsAllowed;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    @Generated
    public String toString() {
        return "PdpPolicyDefinition(id=" + this.getId() + ", policyId=" + this.getPolicyId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", serviceProviderIds=" + String.valueOf(this.getServiceProviderIds()) + ", serviceProviderNames=" + String.valueOf(this.getServiceProviderNames()) + ", serviceProviderNamesNl=" + String.valueOf(this.getServiceProviderNamesNl()) + ", serviceProviderInvalidOrMissing=" + this.isServiceProviderInvalidOrMissing() + ", identityProviderIds=" + String.valueOf(this.getIdentityProviderIds()) + ", identityProviderNames=" + String.valueOf(this.getIdentityProviderNames()) + ", identityProviderNamesNl=" + String.valueOf(this.getIdentityProviderNamesNl()) + ", clientId=" + this.getClientId() + ", attributes=" + String.valueOf(this.getAttributes()) + ", loas=" + String.valueOf(this.getLoas()) + ", denyAdvice=" + this.getDenyAdvice() + ", denyRule=" + this.isDenyRule() + ", allAttributesMustMatch=" + this.isAllAttributesMustMatch() + ", created=" + String.valueOf(this.getCreated()) + ", userDisplayName=" + this.getUserDisplayName() + ", authenticatingAuthorityName=" + this.getAuthenticatingAuthorityName() + ", numberOfViolations=" + this.getNumberOfViolations() + ", numberOfRevisions=" + this.getNumberOfRevisions() + ", denyAdviceNl=" + this.getDenyAdviceNl() + ", revisionNbr=" + this.getRevisionNbr() + ", isActivatedSr=" + this.isActivatedSr() + ", active=" + this.isActive() + ", actionsAllowed=" + this.isActionsAllowed() + ", type=" + this.getType() + ", parentId=" + this.getParentId() + ")";
    }
}

