/*
 * Decompiled with CFR 0.152.
 */
package pdp.mail;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import pdp.mail.DefaultMailBox;
import pdp.mail.MailBox;
import pdp.mail.MockMailBox;

@Configuration
public class MailConfiguration {
    @Value(value="${email.base_url}")
    private String baseUrl;
    @Value(value="${email.from}")
    private String emailFrom;
    @Value(value="${invalid.policies.email.to}")
    private String emailTo;

    @Bean
    @Profile(value={"devconf", "test", "acc", "prod", "mail"})
    public MailBox mailSenderProd() {
        return new DefaultMailBox(this.baseUrl, this.emailTo, this.emailFrom);
    }

    @Bean
    @Profile(value={"dev", "no-csrf", "perf", "local"})
    @Primary
    public MailBox mailSenderDev() {
        return new MockMailBox(this.baseUrl, this.emailTo, this.emailFrom);
    }
}

