/*
 * Decompiled with CFR 0.152.
 */
package pdp.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import java.util.Date;
import lombok.Generated;
import pdp.domain.PdpPolicy;
import pdp.xacml.PolicyTemplateEngine;

@Entity(name="pdp_migrated_policies")
public class PdpMigratedPolicy {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column
    private String policyId;
    @Column
    private String policyXml;
    @Column
    private String name;
    @Column
    private String authenticatingAuthority;
    @Column
    private String userIdentifier;
    @Column
    private String userDisplayName;
    @Column
    private String type;
    @Column(nullable=false, name="ts")
    private Date created;

    public PdpMigratedPolicy(PdpPolicy pdpPolicy) {
        this(pdpPolicy.getPolicyXml(), pdpPolicy.getName(), pdpPolicy.getUserIdentifier(), pdpPolicy.getAuthenticatingAuthority(), pdpPolicy.getUserDisplayName(), pdpPolicy.getType());
    }

    public PdpMigratedPolicy(String policyXml, String name, String userIdentifier, String authenticatingAuthority, String userDisplayName, String type) {
        this.policyXml = policyXml;
        this.name = name;
        this.userIdentifier = userIdentifier;
        this.userDisplayName = userDisplayName;
        this.authenticatingAuthority = authenticatingAuthority;
        this.policyId = PolicyTemplateEngine.getPolicyId((String)name);
        this.type = type;
        this.created = new Date();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getPolicyId() {
        return this.policyId;
    }

    @Generated
    public String getPolicyXml() {
        return this.policyXml;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAuthenticatingAuthority() {
        return this.authenticatingAuthority;
    }

    @Generated
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    @Generated
    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Date getCreated() {
        return this.created;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    @Generated
    public void setPolicyXml(String policyXml) {
        this.policyXml = policyXml;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAuthenticatingAuthority(String authenticatingAuthority) {
        this.authenticatingAuthority = authenticatingAuthority;
    }

    @Generated
    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    @Generated
    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setCreated(Date created) {
        this.created = created;
    }

    @Generated
    public PdpMigratedPolicy() {
    }
}

