/*
 * Decompiled with CFR 0.152.
 */
package pdp.teams;

import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.WebClient;

public class VootClient {
    private static final Logger LOG = LoggerFactory.getLogger(VootClient.class);
    private final String vootServiceUrl;
    private final WebClient vootService;

    public VootClient(WebClient vootService, String vootServiceUrl) {
        this.vootService = vootService;
        this.vootServiceUrl = vootServiceUrl;
    }

    public List<String> groups(String userUrn) {
        long start = System.currentTimeMillis();
        LOG.info("Starting to retrieve groups for {}", (Object)userUrn);
        String uri = this.vootServiceUrl + "/internal/groups/" + userUrn;
        List groups = (List)this.vootService.get().uri(uri, new Object[0]).retrieve().bodyToMono(List.class).block();
        LOG.debug("Retrieved groups: {}", (Object)groups);
        LOG.info("finished retrieving groups for {} in {} ms", (Object)userUrn, (Object)(System.currentTimeMillis() - start));
        return groups.stream().map(entry -> (String)entry.get("id")).collect(Collectors.toList());
    }
}

