/*
 * Decompiled with CFR 0.152.
 */
package pdp.xacml;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithm;
import org.apache.openaz.xacml.pdp.policy.CombiningAlgorithmFactory;
import org.apache.openaz.xacml.pdp.policy.Policy;
import org.apache.openaz.xacml.pdp.policy.PolicyDef;
import org.apache.openaz.xacml.pdp.policy.PolicyFinder;
import org.apache.openaz.xacml.pdp.policy.PolicySet;
import org.apache.openaz.xacml.pdp.policy.PolicySetChild;
import org.apache.openaz.xacml.pdp.policy.Target;
import org.apache.openaz.xacml.pdp.std.StdEvaluationContextFactory;
import org.apache.openaz.xacml.pdp.std.StdPolicyFinder;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdVersion;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.openaz.xacml.util.XACMLProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pdp.domain.PdpPolicy;
import pdp.repositories.PdpPolicyRepository;
import pdp.sab.SabClient;
import pdp.teams.VootClient;
import pdp.xacml.OpenConextConfigurableEngineFinder;
import pdp.xacml.PdpPolicyDefinitionParser;
import pdp.xacml.PolicyTemplateEngine;

public class OpenConextEvaluationContextFactory
extends StdEvaluationContextFactory {
    private static Logger LOG = LoggerFactory.getLogger(OpenConextEvaluationContextFactory.class);
    private final PdpPolicyDefinitionParser policyDefinitionParser = new PdpPolicyDefinitionParser();
    private final PdpPolicyRepository pdpPolicyRepository;
    private final boolean cachePolicies;
    private final boolean includeInactivePolicies;

    public OpenConextEvaluationContextFactory(PdpPolicyRepository pdpPolicyRepository, VootClient vootClient, SabClient sabClient, boolean cachePolicies, boolean includeInactivePolicies) {
        this.pdpPolicyRepository = pdpPolicyRepository;
        this.cachePolicies = cachePolicies;
        this.includeInactivePolicies = includeInactivePolicies;
        this.setPolicyFinder(this.loadPolicyFinder());
        this.setPIPFinder(this.loadPIPFinder(vootClient, sabClient));
    }

    protected PolicyFinder getPolicyFinder() {
        if (this.cachePolicies) {
            return super.getPolicyFinder();
        }
        return this.loadPolicyFinder();
    }

    private PolicyFinder loadPolicyFinder() {
        Collection policies = StreamSupport.stream(this.pdpPolicyRepository.findAll().spliterator(), false).filter(policy -> policy.isActive() || this.includeInactivePolicies).map(policy -> this.convertToPolicyDef(policy)).collect(Collectors.toCollection(ArrayList::new));
        LOG.info("(Re)-loaded {} policies from the database", (Object)policies.size());
        try {
            return new StdPolicyFinder((PolicyDef)this.combinePolicies(policies), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PolicySet combinePolicies(Collection<PolicySetChild> policies) throws IOException, FactoryException, ParseException {
        String combiningAlgorithm = XACMLProperties.getProperties().getProperty("xacml.openaz.policyFinderFactory.combineRootPolicies", "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:deny-overrides");
        CombiningAlgorithm algorithm = CombiningAlgorithmFactory.newInstance().getPolicyCombiningAlgorithm((Identifier)new IdentifierImpl(combiningAlgorithm));
        LOG.info("Combining root policies with " + String.valueOf(algorithm));
        PolicySet root = new PolicySet();
        root.setIdentifier((Identifier)new IdentifierImpl("urn:openconext:pdp:root:policyset"));
        root.setVersion((Version)StdVersion.newInstance((String)"1.0"));
        root.setTarget(new Target());
        root.setPolicyCombiningAlgorithm(algorithm);
        root.setChildren(policies);
        return root;
    }

    private PolicyDef convertToPolicyDef(PdpPolicy pdpPolicy) {
        Policy policyDef = this.policyDefinitionParser.parsePolicy(pdpPolicy.getPolicyXml());
        policyDef.setIdentifier((Identifier)new IdentifierImpl(PolicyTemplateEngine.getPolicyId((String)pdpPolicy.getName())));
        policyDef.getRules().forEachRemaining(rule -> {
            if (rule.getRuleEffect().getDecision().equals((Object)Decision.DENY)) {
                rule.getAdviceExpressions().forEachRemaining(adviceExpression -> adviceExpression.setAdviceId((Identifier)new IdentifierImpl(PolicyTemplateEngine.getPolicyId((String)pdpPolicy.getName()))));
            }
        });
        return policyDef;
    }

    private PIPFinder loadPIPFinder(VootClient vootClient, SabClient sabClient) {
        OpenConextConfigurableEngineFinder pipFinder = new OpenConextConfigurableEngineFinder(vootClient, sabClient);
        try {
            pipFinder.configure(XACMLProperties.getProperties());
            return pipFinder;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

