/*
 * Decompiled with CFR 0.152.
 */
package pdp;

import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import pdp.access.BasicAuthenticationProvider;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    @Value(value="${policy.enforcement.point.user.name}")
    private String policyEnforcementPointUserName;
    @Value(value="${policy.enforcement.point.user.password}")
    private String policyEnforcementPointPassword;

    @Bean
    public SecurityFilterChain apiSecurityConfigurationChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)http.securityMatcher(new String[]{"/**"}).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new String[]{"/internal/health", "/internal/info", "/public/**"})).permitAll().requestMatchers(new String[]{"/protected/**", "/decide/policy", "/manage/**"})).hasRole("PEP").requestMatchers(new String[]{"/internal/**"})).authenticated()).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).csrf(AbstractHttpConfigurer::disable).httpBasic(Customizer.withDefaults()).addFilterBefore((Filter)new BasicAuthenticationFilter((AuthenticationManager)new BasicAuthenticationProvider(this.policyEnforcementPointUserName, this.policyEnforcementPointPassword)), BasicAuthenticationFilter.class).build();
    }
}

